import {Archive} from "@home/models/archive.model";
import {Order} from "@models";
import {LocalStateEnum} from "@shared/enums/local-state.enum";
import {
  BaseAction,
  BaseSubAction,
} from "solidify-frontend";

const state = LocalStateEnum.application_cart;

export namespace AppCartAction {
  export class AddToCart {
    static readonly type: string = `[${state}] Add To Cart`;

    constructor(public archive: Archive) {
    }
  }

  export class RemoveToCart {
    static readonly type: string = `[${state}] Remove To Cart`;

    constructor(public resId: string) {
    }
  }

  export class RemoveAll {
    static readonly type: string = `[${state}] Remove All`;
  }

  export class Clean {
    static readonly type: string = `[${state}] Clean`;
  }

  export class GetAllCart {
    static readonly type: string = `[${state}] Get All Cart`;
  }

  export class Submit extends BaseAction {
    static readonly type: string = `[${state}] Submit Cart`;

    constructor(public order: Order) {
      super();
    }
  }

  export class SubmitSuccess extends BaseSubAction<Submit> {
    static readonly type: string = `[${state}] Submit Success`;

    constructor(public parentAction: Submit, public orderId: string) {
      super(parentAction);
    }
  }

  export class SubmitFail extends BaseSubAction<Submit> {
    static readonly type: string = `[${state}] Submit Fail`;

    constructor(public parentAction: Submit, public orderId: string) {
      super(parentAction);
    }
  }
}

export const appCartActionNameSpace = AppCartAction;
