import {LocalStateEnum} from "@shared/enums/local-state.enum";
import {
  BaseAction,
  BaseSubAction,
} from "solidify-frontend";

const state = LocalStateEnum.application_carousel;

export namespace AppCarouselAction {
  export class GetCarousel extends BaseAction {
    static readonly type: string = `[${state}] Get Carousel`;
  }

  export class GetCarouselSuccess extends BaseSubAction<GetCarousel> {
    static readonly type: string = `[${state}] Get Carousel Success`;

    constructor(public parentAction: GetCarousel, public tiles: Node[]) {
      super(parentAction);
    }
  }

  export class GetCarouselFail extends BaseSubAction<GetCarousel> {
    static readonly type: string = `[${state}] Get Carousel Fail`;
  }
}

export const appCarouselActionNameSpace = AppCarouselAction;
