import {Injectable} from "@angular/core";
import {LocalStateEnum} from "@app/shared/enums/local-state.enum";
import {AppBannerAction} from "@app/stores/banner/app-banner.action";
import {
  Action,
  Actions,
  State,
  StateContext,
  Store,
} from "@ngxs/store";
import {BannerColorEnum} from "@shared/enums/banner-color.enum";
import {LabelTranslateEnum} from "@shared/enums/label-translate.enum";
import {
  ApiService,
  BaseStateModel,
  BasicState,
  defaultBaseStateInitValue,
  NotificationService,
} from "solidify-frontend";

export interface AppBannerStateModel extends BaseStateModel {
  color: BannerColorEnum | undefined;
  message: string | undefined;
  display: boolean;
}

@Injectable()
@State<AppBannerStateModel>({
  name: LocalStateEnum.application_banner,
  defaults: {
    ...defaultBaseStateInitValue(),
    color: undefined,
    message: undefined,
    display: false,
  },
})
export class AppBannerState extends BasicState<AppBannerStateModel> {
  constructor(protected apiService: ApiService,
              protected store: Store,
              protected notificationService: NotificationService,
              protected actions$: Actions) {
    super();
  }

  @Action(AppBannerAction.Show)
  show(ctx: StateContext<AppBannerStateModel>, action: AppBannerAction.Show): void {
    ctx.patchState({
      message: action.message,
      color: action.color,
      display: true,
    });
  }

  @Action(AppBannerAction.ShowInEditMode)
  showInEditMode(ctx: StateContext<AppBannerStateModel>, action: AppBannerAction.ShowInEditMode): void {
    ctx.dispatch(new AppBannerAction.Show(LabelTranslateEnum.youAreInEditMode, BannerColorEnum.warn));
  }

  @Action(AppBannerAction.Hide)
  hide(ctx: StateContext<AppBannerStateModel>, action: AppBannerAction.Hide): void {
    ctx.patchState({
      message: undefined,
      color: undefined,
      display: false,
    });
  }
}
