import {BannerColorEnum} from "@shared/enums/banner-color.enum";
import {LocalStateEnum} from "@shared/enums/local-state.enum";

const state = LocalStateEnum.application_banner;

export namespace AppBannerAction {
  export class Show {
    static readonly type: string = `[${state}] Show`;

    constructor(public message: string, public color: BannerColorEnum) {
    }
  }

  export class ShowInEditMode {
    static readonly type: string = `[${state}] Show In Edit Mode`;
  }

  export class Hide {
    static readonly type: string = `[${state}] Hide`;
  }
}

export const appBannerActionNameSpace = AppBannerAction;
