import {Injectable} from "@angular/core";
import {AdminResourceApiEnum} from "@app/shared/enums/api.enum";
import {appAuthorizedOrganizationalUnitNameSpace} from "@app/stores/authorized-organizational-unit/app-authorized-organizational-unit.action";
import {environment} from "@environments/environment";
import {OrganizationalUnit} from "@models";
import {
  Actions,
  State,
  Store,
} from "@ngxs/store";
import {LocalStateEnum} from "@shared/enums/local-state.enum";
import {
  ApiService,
  defaultResourceStateInitValue,
  MappingObjectUtil,
  NotificationService,
  QueryParameters,
  ResourceState,
  ResourceStateModel,
} from "solidify-frontend";

export interface AppAuthorizedOrganizationalUnitStateModel extends ResourceStateModel<OrganizationalUnit> {
}

// WARNING : IN SOME CASE WE NEED TO FILTER TO GET ONLY OPENED ORG UNIT
const getQueryParameter = () => {
  const queryParameters = new QueryParameters(environment.maximalPageSizeToRetrievePaginationInfo);
  MappingObjectUtil.set(queryParameters.search.searchItems, "openOnly", "false");
  return queryParameters;
};

@Injectable()
@State<AppAuthorizedOrganizationalUnitStateModel>({
  name: LocalStateEnum.application_authorizedOrganizationalUnit,
  defaults: {
    ...defaultResourceStateInitValue(),
    queryParameters: getQueryParameter(),
  },
})
export class AppAuthorizedOrganizationalUnitState extends ResourceState<AppAuthorizedOrganizationalUnitStateModel, OrganizationalUnit> {

  constructor(protected apiService: ApiService,
              protected store: Store,
              protected notificationService: NotificationService,
              protected actions$: Actions) {
    super(apiService, store, notificationService, actions$, {
      nameSpace: appAuthorizedOrganizationalUnitNameSpace,
    });
  }

  protected get _urlResource(): string {
    return AdminResourceApiEnum.authorizedOrganizationalUnits;
  }
}
