import {Injectable} from "@angular/core";
import {appArchiveAclActionNameSpace} from "@app/stores/archive-acl/app-archive-acl.action";
import {environment} from "@environments/environment";
import {ArchiveACL} from "@models";
import {
  Actions,
  State,
  Store,
} from "@ngxs/store";
import {ApiActionEnum} from "@shared/enums/api-action.enum";
import {AdminResourceApiEnum} from "@shared/enums/api.enum";
import {LocalStateEnum} from "@shared/enums/local-state.enum";
import {
  ApiService,
  defaultResourceStateInitValue,
  NotificationService,
  QueryParameters,
  ResourceState,
  ResourceStateModel,
  urlSeparator,
} from "solidify-frontend";

export interface AppArchiveAclStateModel extends ResourceStateModel<ArchiveACL> {
}

@Injectable()
@State<AppArchiveAclStateModel>({
  name: LocalStateEnum.application_archiveAcl,
  defaults: {
    ...defaultResourceStateInitValue(),
    queryParameters: new QueryParameters(environment.defaultEnumValuePageSizeOption),
  },
  children: [],
})
export class AppArchiveAclState extends ResourceState<AppArchiveAclStateModel, ArchiveACL> {
  constructor(protected apiService: ApiService,
              protected store: Store,
              protected notificationService: NotificationService,
              protected actions$: Actions) {
    super(apiService, store, notificationService, actions$, {
      nameSpace: appArchiveAclActionNameSpace,
    });
  }

  protected get _urlResource(): string {
    return AdminResourceApiEnum.archiveAcl + urlSeparator + ApiActionEnum.GET_MY_ACLS;
  }
}
