import {ThemeEnum} from "@app/shared/enums/theme.enum";
import {Enums} from "@enums";
import {GetShortDoiWrapper} from "@shared/components/presentationals/shared-doi-menu/shared-doi-menu.presentational";
import {LocalStateEnum} from "@shared/enums/local-state.enum";
import {
  BaseAction,
  BaseSubAction,
} from "solidify-frontend";

const state = LocalStateEnum.application;

export namespace AppAction {
  export class PreventExit extends BaseAction {
    static readonly type: string = `[${state}] Prevent Exit`;

    constructor(public reasonToTranslate?: string) {
      super();
    }
  }

  export class LoadModuleUrl extends BaseAction {
    static readonly type: string = `[${state}] Load Modules URL From Backend`;
  }

  export class LoadModuleUrlSuccess extends BaseSubAction<LoadModuleUrl> {
    static readonly type: string = `[${state}] Load Modules URL From Backend Success`;

    constructor(public parentAction: LoadModuleUrl, public runtimeConfig: string[]) {
      super(parentAction);
    }
  }

  export class LoadModuleUrlFail extends BaseSubAction<LoadModuleUrl> {
    static readonly type: string = `[${state}] Load Modules URL From Backend Fail`;
  }

  export class CancelPreventExit extends BaseAction {
    static readonly type: string = `[${state}] Cancel Prevent Exit`;
  }

  export class InitApplication extends BaseAction {
    static readonly type: string = `[${state}] Init Application`;
  }

  export class InitApplicationSuccess extends BaseSubAction<InitApplication> {
    static readonly type: string = `[${state}] Init Application Success`;
  }

  export class InitApplicationParallel extends BaseAction {
    static readonly type: string = `[${state}] Init Application Parallel`;
  }

  export class InitApplicationParallelSuccess extends BaseSubAction<InitApplicationParallel> {
    static readonly type: string = `[${state}] Init Application Parallel Success`;
  }

  export class InitApplicationParallelFail extends BaseSubAction<InitApplicationParallel> {
    static readonly type: string = `[${state}] Init Application Fail`;
  }

  export class DefineFallbackLanguage extends BaseAction {
    static readonly type: string = `[${state}] Set Default Language`;
  }

  export class SetMomentLocal extends BaseAction {
    static readonly type: string = `[${state}] Set Moment Local`;
  }

  export class ChangeAppLanguage extends BaseAction {
    static readonly type: string = `[${state}] Change App Language`;

    constructor(public language: Enums.Language.LanguageEnum) {
      super();
    }
  }

  export class ChangeAppLanguageSuccess extends BaseSubAction<ChangeAppLanguage> {
    static readonly type: string = `[${state}] Change App Language Success`;
  }

  export class ChangeAppTheme extends BaseAction {
    static readonly type: string = `[${state}] Change App Theme`;

    constructor(public theme: ThemeEnum) {
      super();
    }
  }

  export class LoadCart extends BaseAction {
    static readonly type: string = `[${state}] Load Cart`;
  }

  export class StartPollingOrder extends BaseAction {
    static readonly type: string = `[${state}] Start Polling Order`;
  }

  export class StartPollingNotification extends BaseAction {
    static readonly type: string = `[${state}] Start Polling Notification`;
  }

  export class UpdateNotificationInbox {
    static readonly type: string = `[${state}] Update Notification Inbox`;
  }

  export class Login extends BaseAction {
    static readonly type: string = `[${state}] Login`;
  }

  export class LoginSuccess extends BaseSubAction<Login> {
    static readonly type: string = `[${state}] Login Success`;
  }

  export class LoginFail extends BaseSubAction<Login> {
    static readonly type: string = `[${state}] Login Fail`;
  }

  export class Logout extends BaseAction {
    static readonly type: string = `[${state}] Logout`;
  }

  export class GetShortDoi extends BaseAction {
    static readonly type: string = `[${state}] Get Short DOI`;

    constructor(public doiWrapper: GetShortDoiWrapper) {
      super();
    }
  }

  export class ChangeDisplaySidebarUserGuide extends BaseAction {
    static readonly type: string = `[${state}] Change Display Sidebar UserGuide`;

    constructor(public isOpen: boolean) {
      super();
    }
  }

  export class GetShortDoiSuccess extends BaseSubAction<GetShortDoi> {
    static readonly type: string = `[${state}] Get Short DOI Success`;

    constructor(public parent: GetShortDoi, public shortDoi: string) {
      super(parent);
    }
  }

  export class GetShortDoiFail extends BaseSubAction<GetShortDoi> {
    static readonly type: string = `[${state}] Get Short DOI Fail`;

    constructor(public parent: GetShortDoi) {
      super(parent);
    }
  }

  export class SetIsInTourMode extends BaseAction {
    static readonly type: string = `[${state}] Set Is In Tour Mode`;

    constructor(public isInTourMode: boolean) {
      super();
    }
  }

  export class SetIsTouchInterface extends BaseAction {
    static readonly type: string = `[${state}] Set Is Touch Interface`;

    constructor(public isTouchInterface: boolean) {
      super();
    }
  }

  export class DisplayCookieConsent extends BaseAction {
    static readonly type: string = `[${state}] Display Cookie Consent`;

    constructor(public display: boolean) {
      super();
    }
  }
}
