import {
  DepositRoutesEnum,
  RoutesEnum,
} from "@app/shared/enums/routes.enum";
import {
  StringUtil,
  urlSeparator,
} from "solidify-frontend";
import {LocalStateEnum} from "../enums/local-state.enum";

export class StoreRouteLocalUtil {
  private static readonly messageNotFound: string = "There is no route declared for '{0}' for the state '{1}'. Please add if statement into StoreRouteLocalUtil static class to manage this state.";

  static getDetailRoute(state: LocalStateEnum): RoutesEnum {
    if (state === LocalStateEnum.deposit) {
      return RoutesEnum.depositDetail;
    }
    if (state === LocalStateEnum.preservationSpace_organizationalUnit) {
      return RoutesEnum.preservationSpaceOrganizationalUnitDetail;
    }
    if (state === LocalStateEnum.admin_organizationalUnit) {
      return RoutesEnum.adminOrganizationalUnitDetail;
    }
    if (state === LocalStateEnum.admin_submissionPolicy) {
      return RoutesEnum.adminSubmissionPolicyDetail;
    }
    if (state === LocalStateEnum.admin_preservationPolicy) {
      return RoutesEnum.adminPreservationPolicyDetail;
    }
    if (state === LocalStateEnum.admin_disseminationPolicy) {
      return RoutesEnum.adminDisseminationPolicyDetail;
    }
    if (state === LocalStateEnum.admin_license) {
      return RoutesEnum.adminLicenseDetail;
    }
    if (state === LocalStateEnum.admin_institution) {
      return RoutesEnum.adminInstitutionDetail;
    }
    if (state === LocalStateEnum.admin_user) {
      return RoutesEnum.adminUserDetail;
    }
    if (state === LocalStateEnum.admin_oaiSet) {
      return RoutesEnum.adminOaiSetDetail;
    }
    if (state === LocalStateEnum.admin_oauth2Client) {
      return RoutesEnum.adminOAuth2clientDetail;
    }
    if (state === LocalStateEnum.admin_person) {
      return RoutesEnum.adminPersonDetail;
    }
    if (state === LocalStateEnum.admin_role) {
      return RoutesEnum.adminRoleDetail;
    }
    if (state === LocalStateEnum.admin_notification) {
      return RoutesEnum.adminNotificationDetail;
    }
    if (state === LocalStateEnum.admin_fundingAgencies) {
      return RoutesEnum.adminFundingAgenciesDetail;
    }
    if (state === LocalStateEnum.admin_indexFieldAlias) {
      return RoutesEnum.adminIndexFieldAliasDetail;
    }
    if (state === LocalStateEnum.admin_archiveAcl) {
      return RoutesEnum.adminArchiveAclDetail;
    }
    if (state === LocalStateEnum.admin_metadataType) {
      return RoutesEnum.adminMetadataTypeDetail;
    }
    if (state === LocalStateEnum.preservationPlanning_job) {
      return RoutesEnum.preservationPlanningJobDetail;
    }
    if (state === LocalStateEnum.preservationPlanning_sip) {
      return RoutesEnum.preservationPlanningSipDetail;
    }
    if (state === LocalStateEnum.preservationPlanning_dip) {
      return RoutesEnum.preservationPlanningDipDetail;
    }
    if (state === LocalStateEnum.preservationPlanning_aipDownloaded) {
      return RoutesEnum.preservationPlanningAipDownloadedDetail;
    }
    if (state === LocalStateEnum.order_allOrder) {
      return RoutesEnum.orderAllOrderDetail;
    }
    if (state === LocalStateEnum.order_myOrder) {
      return RoutesEnum.orderMyOrderDetail;
    }
    if (state === LocalStateEnum.preservationSpace_contributor) {
      return RoutesEnum.preservationSpaceContributorDetail;
    }
    if (state === LocalStateEnum.preservationSpace_notification) {
      return RoutesEnum.preservationSpaceNotificationInboxDetail;
    }
    throw Error(StringUtil.format(StoreRouteLocalUtil.messageNotFound, "Detail", state));
  }

  static getCreateRoute(state: LocalStateEnum): RoutesEnum {
    if (state === LocalStateEnum.deposit) {
      return RoutesEnum.depositCreate;
    }
    if (state === LocalStateEnum.admin_organizationalUnit) {
      return RoutesEnum.adminOrganizationalUnitCreate;
    }
    if (state === LocalStateEnum.admin_submissionPolicy) {
      return RoutesEnum.adminSubmissionPolicyCreate;
    }
    if (state === LocalStateEnum.admin_preservationPolicy) {
      return RoutesEnum.adminPreservationPolicyCreate;
    }
    if (state === LocalStateEnum.admin_disseminationPolicy) {
      return RoutesEnum.adminDisseminationPolicyCreate;
    }
    if (state === LocalStateEnum.admin_license) {
      return RoutesEnum.adminLicenseCreate;
    }
    if (state === LocalStateEnum.admin_institution) {
      return RoutesEnum.adminInstitutionCreate;
    }
    if (state === LocalStateEnum.admin_user) {
      return RoutesEnum.adminUserCreate;
    }
    if (state === LocalStateEnum.admin_oaiSet) {
      return RoutesEnum.adminOaiSetCreate;
    }
    if (state === LocalStateEnum.admin_oauth2Client) {
      return RoutesEnum.adminOAuth2clientCreate;
    }
    if (state === LocalStateEnum.admin_person) {
      return RoutesEnum.adminPersonCreate;
    }
    if (state === LocalStateEnum.admin_role) {
      return RoutesEnum.adminRoleCreate;
    }
    if (state === LocalStateEnum.admin_notification) {
      return RoutesEnum.adminNotificationCreate;
    }
    if (state === LocalStateEnum.admin_fundingAgencies) {
      return RoutesEnum.adminFundingAgenciesCreate;
    }
    if (state === LocalStateEnum.admin_indexFieldAlias) {
      return RoutesEnum.adminIndexFieldAliasCreate;
    }
    if (state === LocalStateEnum.admin_archiveAcl) {
      return RoutesEnum.adminArchiveAclCreate;
    }
    if (state === LocalStateEnum.admin_metadataType) {
      return RoutesEnum.adminMetadataTypeCreate;
    }
    if (state === LocalStateEnum.preservationPlanning_job) {
      return RoutesEnum.preservationPlanningJobCreate;
    }
    if (state === LocalStateEnum.order_allOrder) {
      return RoutesEnum.orderAllOrderCreate;
    }
    throw Error(StringUtil.format(StoreRouteLocalUtil.messageNotFound, "Create", state));
  }

  static getRootRoute(state: LocalStateEnum): RoutesEnum {
    if (state === LocalStateEnum.deposit) {
      return RoutesEnum.deposit;
    }
    if (state === LocalStateEnum.preservationSpace_organizationalUnit) {
      return RoutesEnum.preservationSpaceOrganizationalUnit;
    }
    if (state === LocalStateEnum.admin_organizationalUnit) {
      return RoutesEnum.adminOrganizationalUnit;
    }
    if (state === LocalStateEnum.admin_submissionPolicy) {
      return RoutesEnum.adminSubmissionPolicy;
    }
    if (state === LocalStateEnum.admin_preservationPolicy) {
      return RoutesEnum.adminPreservationPolicy;
    }
    if (state === LocalStateEnum.admin_disseminationPolicy) {
      return RoutesEnum.adminDisseminationPolicy;
    }
    if (state === LocalStateEnum.admin_license) {
      return RoutesEnum.adminLicense;
    }
    if (state === LocalStateEnum.admin_institution) {
      return RoutesEnum.adminInstitution;
    }
    if (state === LocalStateEnum.admin_researchDomain) {
      return RoutesEnum.adminResearchDomain;
    }
    if (state === LocalStateEnum.admin_user) {
      return RoutesEnum.adminUser;
    }
    if (state === LocalStateEnum.admin_oaiSet) {
      return RoutesEnum.adminOaiSet;
    }
    if (state === LocalStateEnum.admin_oauth2Client) {
      return RoutesEnum.adminOAuth2client;
    }
    if (state === LocalStateEnum.admin_person) {
      return RoutesEnum.adminPerson;
    }
    if (state === LocalStateEnum.admin_role) {
      return RoutesEnum.adminRole;
    }
    if (state === LocalStateEnum.admin_notification) {
      return RoutesEnum.adminNotification;
    }
    if (state === LocalStateEnum.admin_fundingAgencies) {
      return RoutesEnum.adminFundingAgencies;
    }
    if (state === LocalStateEnum.admin_indexFieldAlias) {
      return RoutesEnum.adminIndexFieldAlias;
    }
    if (state === LocalStateEnum.admin_archiveAcl) {
      return RoutesEnum.adminArchiveAcl;
    }
    if (state === LocalStateEnum.admin_metadataType) {
      return RoutesEnum.adminMetadataType;
    }
    if (state === LocalStateEnum.preservationPlanning_job) {
      return RoutesEnum.preservationPlanningJob;
    }
    if (state === LocalStateEnum.preservationPlanning_sip) {
      return RoutesEnum.preservationPlanningSip;
    }
    if (state === LocalStateEnum.preservationPlanning_deposit) {
      return RoutesEnum.preservationPlanningDeposit;
    }
    if (state === LocalStateEnum.order_allOrder) {
      return RoutesEnum.orderAllOrder;
    }
    if (state === LocalStateEnum.order_myOrder) {
      return RoutesEnum.orderMyOrder;
    }
    if (state === LocalStateEnum.preservationPlanning_dip) {
      return RoutesEnum.preservationPlanningDip;
    }
    if (state === LocalStateEnum.preservationPlanning_aipDownloaded) {
      return RoutesEnum.preservationPlanningAipDownloaded;
    }
    if (state === LocalStateEnum.preservationSpace_contributor) {
      return RoutesEnum.preservationSpaceContributor;
    }
    if (state === LocalStateEnum.preservationSpace_notification) {
      return RoutesEnum.preservationSpaceNotificationInbox;
    }
    throw Error(StringUtil.format(StoreRouteLocalUtil.messageNotFound, "Root", state));
  }

  static getEditRoute(state: LocalStateEnum, id: string): RoutesEnum {
    const detailRoute = this.getDetailRoute(state);
    return detailRoute + urlSeparator + id + urlSeparator + DepositRoutesEnum.edit;
  }
}
