import {adminArchiveAclActionNameSpace} from "@admin/archive-acl/stores/admin-archive-acl.action";
import {adminDisseminationPolicyActionNameSpace} from "@admin/dissemination-policy/stores/admin-dissemination-policy.action";
import {adminFundingAgenciesActionNameSpace} from "@admin/funding-agencies/stores/admin-funding-agencies.action";
import {adminIndexFieldAliasActionNameSpace} from "@admin/index-field-alias/stores/admin-index-field-alias.action";
import {adminInstitutionActionNameSpace} from "@admin/institution/stores/admin-institution.action";
import {adminLanguageActionNameSpace} from "@admin/language/stores/admin-language.action";
import {adminLicenseActionNameSpace} from "@admin/license/stores/admin-license.action";
import {adminMetadataTypeActionNameSpace} from "@admin/metadata-type/stores/admin-metadata-type.action";
import {adminOaiSetActionNameSpace} from "@admin/oai-set/stores/admin-oai-set.action";
import {adminOAuth2ClientActionNameSpace} from "@admin/oauth2-client/stores/admin-oauth2-client.action";
import {adminOrganizationalUnitActionNameSpace} from "@admin/organizational-unit/stores/admin-organizational-unit.action";
import {adminPersonActionNameSpace} from "@admin/person/stores/admin-person.action";
import {adminPreservationPolicyActionNameSpace} from "@admin/preservation-policy/stores/admin-preservation-policy.action";
import {adminResearchDomainActionNameSpace} from "@admin/research-domain/stores/admin-research-domain.action";
import {adminSubmissionPolicyActionNameSpace} from "@admin/submission-policy/stores/admin-submission-policy.action";
import {adminUserActionNameSpace} from "@admin/user/stores/admin-user.action";
import {LocalStateEnum} from "@app/shared/enums/local-state.enum";
import {depositActionNameSpace} from "@deposit/stores/deposit.action";
import {orderAllOrderActionNameSpace} from "@order/features/all-order/stores/order-all-order.action";
import {orderMyOrderActionNameSpace} from "@order/features/my-order/stores/order-my-order.action";
import {preservationPlanningJobActionNameSpace} from "@preservation-planning/job/stores/preservation-planning-job.action";
import {SharedDeleteDialogData} from "@shared/components/dialogs/shared-abstract-delete/shared-delete.dialog";
import {sharedArchiveAclActionNameSpace} from "@shared/stores/archive-acl/shared-archive-acl.action";
import {
  isNotNullNorUndefined,
  MARK_AS_TRANSLATABLE,
  StringUtil,
} from "solidify-frontend";

export class StoreDialogUtil {
  private static readonly messageNotFound: string = "There is no dialog for action '{0}' declared for the state '{1}'. Please add if statement into StoreDialogUtil static class.";

  static deleteData(state: LocalStateEnum): SharedDeleteDialogData {
    const sharedDeleteDialogData = {} as SharedDeleteDialogData;
    if (state === LocalStateEnum.deposit) {
      sharedDeleteDialogData.message = MARK_AS_TRANSLATABLE("deposit.dialog.delete.message");
      sharedDeleteDialogData.resourceNameSpace = depositActionNameSpace;
    }
    if (state === LocalStateEnum.admin_organizationalUnit) {
      sharedDeleteDialogData.message = MARK_AS_TRANSLATABLE("admin.organizationalUnit.dialog.delete.message");
      sharedDeleteDialogData.resourceNameSpace = adminOrganizationalUnitActionNameSpace;
    }
    if (state === LocalStateEnum.admin_submissionPolicy) {
      sharedDeleteDialogData.message = MARK_AS_TRANSLATABLE("admin.submissionPolicy.dialog.delete.message");
      sharedDeleteDialogData.resourceNameSpace = adminSubmissionPolicyActionNameSpace;
    }
    if (state === LocalStateEnum.admin_preservationPolicy) {
      sharedDeleteDialogData.message = MARK_AS_TRANSLATABLE("admin.preservationPolicy.dialog.delete.message");
      sharedDeleteDialogData.resourceNameSpace = adminPreservationPolicyActionNameSpace;
    }
    if (state === LocalStateEnum.admin_disseminationPolicy) {
      sharedDeleteDialogData.message = MARK_AS_TRANSLATABLE("admin.disseminationPolicy.dialog.delete.message");
      sharedDeleteDialogData.resourceNameSpace = adminDisseminationPolicyActionNameSpace;
    }
    if (state === LocalStateEnum.admin_license) {
      sharedDeleteDialogData.message = MARK_AS_TRANSLATABLE("admin.license.dialog.delete.message");
      sharedDeleteDialogData.resourceNameSpace = adminLicenseActionNameSpace;
    }
    if (state === LocalStateEnum.admin_institution) {
      sharedDeleteDialogData.message = MARK_AS_TRANSLATABLE("admin.institution.dialog.delete.message");
      sharedDeleteDialogData.resourceNameSpace = adminInstitutionActionNameSpace;
    }
    if (state === LocalStateEnum.admin_researchDomain) {
      sharedDeleteDialogData.message = MARK_AS_TRANSLATABLE("admin.researchDomain.dialog.delete.message");
      sharedDeleteDialogData.resourceNameSpace = adminResearchDomainActionNameSpace;
    }
    if (state === LocalStateEnum.admin_user) {
      sharedDeleteDialogData.message = MARK_AS_TRANSLATABLE("admin.user.dialog.delete.message");
      sharedDeleteDialogData.resourceNameSpace = adminUserActionNameSpace;
    }
    if (state === LocalStateEnum.admin_oaiSet) {
      sharedDeleteDialogData.message = MARK_AS_TRANSLATABLE("admin.oai-set.dialog.delete.message");
      sharedDeleteDialogData.resourceNameSpace = adminOaiSetActionNameSpace;
    }
    if (state === LocalStateEnum.admin_oauth2Client) {
      sharedDeleteDialogData.message = MARK_AS_TRANSLATABLE("admin.oauth2.dialog.delete.message");
      sharedDeleteDialogData.resourceNameSpace = adminOAuth2ClientActionNameSpace;
    }
    if (state === LocalStateEnum.admin_person) {
      sharedDeleteDialogData.message = MARK_AS_TRANSLATABLE("admin.person.dialog.delete.message");
      sharedDeleteDialogData.resourceNameSpace = adminPersonActionNameSpace;
    }
    if (state === LocalStateEnum.admin_fundingAgencies) {
      sharedDeleteDialogData.message = MARK_AS_TRANSLATABLE("admin.funding-agencies.dialog.delete.message");
      sharedDeleteDialogData.resourceNameSpace = adminFundingAgenciesActionNameSpace;
    }
    if (state === LocalStateEnum.admin_indexFieldAlias) {
      sharedDeleteDialogData.message = MARK_AS_TRANSLATABLE("admin.index-field-alias.dialog.delete.message");
      sharedDeleteDialogData.resourceNameSpace = adminIndexFieldAliasActionNameSpace;
    }
    if (state === LocalStateEnum.admin_archiveAcl) {
      sharedDeleteDialogData.message = MARK_AS_TRANSLATABLE("admin.archive-acl.dialog.delete.message");
      sharedDeleteDialogData.resourceNameSpace = adminArchiveAclActionNameSpace;
    }
    if (state === LocalStateEnum.preservationSpace_organizationalUnit_archiveAcl) {
      sharedDeleteDialogData.message = MARK_AS_TRANSLATABLE("admin.archive-acl.dialog.delete.message");
      sharedDeleteDialogData.resourceNameSpace = sharedArchiveAclActionNameSpace;
    }
    if (state === LocalStateEnum.admin_language) {
      sharedDeleteDialogData.message = MARK_AS_TRANSLATABLE("admin.language.dialog.delete.message");
      sharedDeleteDialogData.resourceNameSpace = adminLanguageActionNameSpace;
    }
    if (state === LocalStateEnum.admin_metadataType) {
      sharedDeleteDialogData.message = MARK_AS_TRANSLATABLE("admin.metadataType.dialog.delete.message");
      sharedDeleteDialogData.resourceNameSpace = adminMetadataTypeActionNameSpace;
    }
    if (state === LocalStateEnum.preservationPlanning_job) {
      sharedDeleteDialogData.message = MARK_AS_TRANSLATABLE("preservation.job.dialog.delete.message");
      sharedDeleteDialogData.resourceNameSpace = preservationPlanningJobActionNameSpace;
    }
    if (state === LocalStateEnum.order_allOrder) {
      sharedDeleteDialogData.message = MARK_AS_TRANSLATABLE("order.allOrder.dialog.delete.message");
      sharedDeleteDialogData.resourceNameSpace = orderAllOrderActionNameSpace;
    }
    if (state === LocalStateEnum.order_myOrder) {
      sharedDeleteDialogData.message = MARK_AS_TRANSLATABLE("order.myOrder.dialog.delete.message");
      sharedDeleteDialogData.resourceNameSpace = orderMyOrderActionNameSpace;
    }
    if (isNotNullNorUndefined(sharedDeleteDialogData.message)) {
      return sharedDeleteDialogData;
    }
    throw Error(StringUtil.format(StoreDialogUtil.messageNotFound, "Delete", state));
  }
}
