import {
  ActivatedRoute,
  ActivatedRouteSnapshot,
  UrlSegment,
} from "@angular/router";
import {AppRoutesEnum} from "@shared/enums/routes.enum";

export class RouteUtil {
  static generateFullUrlFromActivatedRouteNormal(route: ActivatedRoute): string[] {
    return this.generateFullUrlFromActivatedRouteSnapshot(route.snapshot);
  }

  static generateFullUrlStringFromActivatedRouteNormal(route: ActivatedRoute): string {
    return this.generateFullUrlFromActivatedRouteNormal(route).join(AppRoutesEnum.separator);
  }

  static generateFullUrlFromActivatedRouteSnapshot(route: ActivatedRouteSnapshot): string[] {
    const urlSegmentToParent: UrlSegment[] = [];
    route.pathFromRoot.forEach((activatedRouteSnap) => {
      urlSegmentToParent.push(...activatedRouteSnap.url);
    });
    return urlSegmentToParent.map(u => u.path);
  }

  static generateFullUrlStringFromActivatedRouteSnapshot(route: ActivatedRouteSnapshot): string {
    return this.generateFullUrlFromActivatedRouteSnapshot(route).join(AppRoutesEnum.separator);
  }
}
