import {ApplicationRolePermissionEnum} from "@app/shared/enums/application-role-permission.enum";
import {Enums} from "@enums";
import {
  isEmptyArray,
  isFalse,
  isNullOrUndefined,
} from "solidify-frontend";

export class PermissionUtil {
  static isRootPermission(userRoles: Enums.UserApplicationRole.UserApplicationRoleEnum[]): boolean {
    return userRoles.includes(Enums.UserApplicationRole.UserApplicationRoleEnum.root);
  }

  static isAdminPermission(userRoles: Enums.UserApplicationRole.UserApplicationRoleEnum[]): boolean {
    return userRoles.includes(Enums.UserApplicationRole.UserApplicationRoleEnum.admin) || userRoles.includes(Enums.UserApplicationRole.UserApplicationRoleEnum.root);
  }

  static isUserPermission(userRoles: Enums.UserApplicationRole.UserApplicationRoleEnum[]): boolean {
    return userRoles.includes(Enums.UserApplicationRole.UserApplicationRoleEnum.user) || userRoles.includes(Enums.UserApplicationRole.UserApplicationRoleEnum.admin) || userRoles.includes(Enums.UserApplicationRole.UserApplicationRoleEnum.root);
  }

  static isNoPermission(userRoles: Enums.UserApplicationRole.UserApplicationRoleEnum[]): boolean {
    return isNullOrUndefined(userRoles)
      || isEmptyArray(userRoles)
      || userRoles.includes(Enums.UserApplicationRole.UserApplicationRoleEnum.guest)
      || userRoles.includes(Enums.UserApplicationRole.UserApplicationRoleEnum.user)
      || userRoles.includes(Enums.UserApplicationRole.UserApplicationRoleEnum.admin)
      || userRoles.includes(Enums.UserApplicationRole.UserApplicationRoleEnum.root);
  }

  static isUserHavePermission(isLogged: boolean, permission: ApplicationRolePermissionEnum, currentUserRole: Enums.UserApplicationRole.UserApplicationRoleEnum[]): boolean {
    if (isNullOrUndefined(permission) || permission === ApplicationRolePermissionEnum.noPermission) {
      return this.isNoPermission(currentUserRole);
    }

    if (isFalse(isLogged) || isNullOrUndefined(currentUserRole) || isEmptyArray(currentUserRole)) {
      return false;
    }

    switch (permission) {
      case ApplicationRolePermissionEnum.rootPermission:
        return this.isRootPermission(currentUserRole);
      case ApplicationRolePermissionEnum.adminPermission:
        return this.isAdminPermission(currentUserRole);
      case ApplicationRolePermissionEnum.userPermission:
        return this.isUserPermission(currentUserRole);
      default:
        return true;
    }
  }
}
