import {PermissionUtil} from "@app/shared/utils/permission.util";
import {Enums} from "@enums";

describe("RoleUtil", () => {
  describe("isRootPermission", () => {
    it("should return true when user is ROOT", () => {
      const userRoles = [Enums.UserApplicationRole.UserApplicationRoleEnum.root];
      expect(PermissionUtil.isRootPermission(userRoles)).toBeTruthy();
    });

    it("should return false when user is ADMIN", () => {
      const userRoles = [Enums.UserApplicationRole.UserApplicationRoleEnum.admin];
      expect(PermissionUtil.isRootPermission(userRoles)).toBeFalsy();
    });

    it("should return false when user is USER", () => {
      const userRoles = [Enums.UserApplicationRole.UserApplicationRoleEnum.user];
      expect(PermissionUtil.isRootPermission(userRoles)).toBeFalsy();
    });

    it("should return false when user is GUEST", () => {
      const userRoles = [Enums.UserApplicationRole.UserApplicationRoleEnum.guest];
      expect(PermissionUtil.isRootPermission(userRoles)).toBeFalsy();
    });

    it("should return false when user have no role", () => {
      const userRoles = [];
      expect(PermissionUtil.isRootPermission(userRoles)).toBeFalsy();
    });

    it("should return true when user is [ROOT, ADMIN]", () => {
      const userRoles = [Enums.UserApplicationRole.UserApplicationRoleEnum.root, Enums.UserApplicationRole.UserApplicationRoleEnum.admin];
      expect(PermissionUtil.isRootPermission(userRoles)).toBeTruthy();
    });

    it("should return true when user is [ROOT, ADMIN, USER]", () => {
      const userRoles = [Enums.UserApplicationRole.UserApplicationRoleEnum.root, Enums.UserApplicationRole.UserApplicationRoleEnum.admin, Enums.UserApplicationRole.UserApplicationRoleEnum.user];
      expect(PermissionUtil.isRootPermission(userRoles)).toBeTruthy();
    });

    it("should return true when user is [ROOT, USER]", () => {
      const userRoles = [Enums.UserApplicationRole.UserApplicationRoleEnum.root, Enums.UserApplicationRole.UserApplicationRoleEnum.user];
      expect(PermissionUtil.isRootPermission(userRoles)).toBeTruthy();
    });

    it("should return false when user is [ADMIN, USER]", () => {
      const userRoles = [Enums.UserApplicationRole.UserApplicationRoleEnum.admin, Enums.UserApplicationRole.UserApplicationRoleEnum.user];
      expect(PermissionUtil.isRootPermission(userRoles)).toBeFalsy();
    });

    it("should return false when user is [GUEST, USER]", () => {
      const userRoles = [Enums.UserApplicationRole.UserApplicationRoleEnum.guest, Enums.UserApplicationRole.UserApplicationRoleEnum.user];
      expect(PermissionUtil.isRootPermission(userRoles)).toBeFalsy();
    });
  });

  describe("isAdminPermission", () => {
    it("should return true when user is ROOT", () => {
      const userRoles = [Enums.UserApplicationRole.UserApplicationRoleEnum.root];
      expect(PermissionUtil.isAdminPermission(userRoles)).toBeTruthy();
    });

    it("should return true when user is ADMIN", () => {
      const userRoles = [Enums.UserApplicationRole.UserApplicationRoleEnum.admin];
      expect(PermissionUtil.isAdminPermission(userRoles)).toBeTruthy();
    });

    it("should return false when user is USER", () => {
      const userRoles = [Enums.UserApplicationRole.UserApplicationRoleEnum.user];
      expect(PermissionUtil.isAdminPermission(userRoles)).toBeFalsy();
    });

    it("should return false when user is GUEST", () => {
      const userRoles = [Enums.UserApplicationRole.UserApplicationRoleEnum.guest];
      expect(PermissionUtil.isAdminPermission(userRoles)).toBeFalsy();
    });

    it("should return false when user have no role", () => {
      const userRoles = [];
      expect(PermissionUtil.isAdminPermission(userRoles)).toBeFalsy();
    });

    it("should return true when user is [ROOT, ADMIN]", () => {
      const userRoles = [Enums.UserApplicationRole.UserApplicationRoleEnum.root, Enums.UserApplicationRole.UserApplicationRoleEnum.admin];
      expect(PermissionUtil.isAdminPermission(userRoles)).toBeTruthy();
    });

    it("should return true when user is [ROOT, ADMIN, USER]", () => {
      const userRoles = [Enums.UserApplicationRole.UserApplicationRoleEnum.root, Enums.UserApplicationRole.UserApplicationRoleEnum.admin, Enums.UserApplicationRole.UserApplicationRoleEnum.user];
      expect(PermissionUtil.isAdminPermission(userRoles)).toBeTruthy();
    });

    it("should return true when user is [ROOT, USER]", () => {
      const userRoles = [Enums.UserApplicationRole.UserApplicationRoleEnum.root, Enums.UserApplicationRole.UserApplicationRoleEnum.user];
      expect(PermissionUtil.isAdminPermission(userRoles)).toBeTruthy();
    });

    it("should return true when user is [ADMIN, USER]", () => {
      const userRoles = [Enums.UserApplicationRole.UserApplicationRoleEnum.admin, Enums.UserApplicationRole.UserApplicationRoleEnum.user];
      expect(PermissionUtil.isAdminPermission(userRoles)).toBeTruthy();
    });

    it("should return false when user is [GUEST, USER]", () => {
      const userRoles = [Enums.UserApplicationRole.UserApplicationRoleEnum.guest, Enums.UserApplicationRole.UserApplicationRoleEnum.user];
      expect(PermissionUtil.isAdminPermission(userRoles)).toBeFalsy();
    });
  });

  describe("isUser", () => {
    it("should return true when user is ROOT", () => {
      const userRoles = [Enums.UserApplicationRole.UserApplicationRoleEnum.root];
      expect(PermissionUtil.isUserPermission(userRoles)).toBeTruthy();
    });

    it("should return true when user is ADMIN", () => {
      const userRoles = [Enums.UserApplicationRole.UserApplicationRoleEnum.admin];
      expect(PermissionUtil.isUserPermission(userRoles)).toBeTruthy();
    });

    it("should return true when user is USER", () => {
      const userRoles = [Enums.UserApplicationRole.UserApplicationRoleEnum.user];
      expect(PermissionUtil.isUserPermission(userRoles)).toBeTruthy();
    });

    it("should return false when user is GUEST", () => {
      const userRoles = [Enums.UserApplicationRole.UserApplicationRoleEnum.guest];
      expect(PermissionUtil.isUserPermission(userRoles)).toBeFalsy();
    });

    it("should return false when user have no role", () => {
      const userRoles = [];
      expect(PermissionUtil.isUserPermission(userRoles)).toBeFalsy();
    });

    it("should return true when user is [ROOT, ADMIN]", () => {
      const userRoles = [Enums.UserApplicationRole.UserApplicationRoleEnum.root, Enums.UserApplicationRole.UserApplicationRoleEnum.admin];
      expect(PermissionUtil.isUserPermission(userRoles)).toBeTruthy();
    });

    it("should return true when user is [ROOT, ADMIN, USER]", () => {
      const userRoles = [Enums.UserApplicationRole.UserApplicationRoleEnum.root, Enums.UserApplicationRole.UserApplicationRoleEnum.admin, Enums.UserApplicationRole.UserApplicationRoleEnum.user];
      expect(PermissionUtil.isUserPermission(userRoles)).toBeTruthy();
    });

    it("should return true when user is [ROOT, USER]", () => {
      const userRoles = [Enums.UserApplicationRole.UserApplicationRoleEnum.root, Enums.UserApplicationRole.UserApplicationRoleEnum.user];
      expect(PermissionUtil.isUserPermission(userRoles)).toBeTruthy();
    });

    it("should return true when user is [ADMIN, USER]", () => {
      const userRoles = [Enums.UserApplicationRole.UserApplicationRoleEnum.admin, Enums.UserApplicationRole.UserApplicationRoleEnum.user];
      expect(PermissionUtil.isUserPermission(userRoles)).toBeTruthy();
    });

    it("should return true when user is [GUEST, USER]", () => {
      const userRoles = [Enums.UserApplicationRole.UserApplicationRoleEnum.guest, Enums.UserApplicationRole.UserApplicationRoleEnum.user];
      expect(PermissionUtil.isUserPermission(userRoles)).toBeTruthy();
    });
  });

  describe("isNoPermission", () => {
    it("should return true when user is ROOT", () => {
      const userRoles = [Enums.UserApplicationRole.UserApplicationRoleEnum.root];
      expect(PermissionUtil.isNoPermission(userRoles)).toBeTruthy();
    });

    it("should return true when user is ADMIN", () => {
      const userRoles = [Enums.UserApplicationRole.UserApplicationRoleEnum.admin];
      expect(PermissionUtil.isNoPermission(userRoles)).toBeTruthy();
    });

    it("should return true when user is USER", () => {
      const userRoles = [Enums.UserApplicationRole.UserApplicationRoleEnum.user];
      expect(PermissionUtil.isNoPermission(userRoles)).toBeTruthy();
    });

    it("should return true when user is GUEST", () => {
      const userRoles = [Enums.UserApplicationRole.UserApplicationRoleEnum.guest];
      expect(PermissionUtil.isNoPermission(userRoles)).toBeTruthy();
    });

    it("should return true when user have no role", () => {
      const userRoles = [];
      expect(PermissionUtil.isNoPermission(userRoles)).toBeTruthy();
    });

    it("should return true when user is [ROOT, ADMIN]", () => {
      const userRoles = [Enums.UserApplicationRole.UserApplicationRoleEnum.root, Enums.UserApplicationRole.UserApplicationRoleEnum.admin];
      expect(PermissionUtil.isNoPermission(userRoles)).toBeTruthy();
    });

    it("should return true when user is [ROOT, ADMIN, USER]", () => {
      const userRoles = [Enums.UserApplicationRole.UserApplicationRoleEnum.root, Enums.UserApplicationRole.UserApplicationRoleEnum.admin, Enums.UserApplicationRole.UserApplicationRoleEnum.user];
      expect(PermissionUtil.isNoPermission(userRoles)).toBeTruthy();
    });

    it("should return true when user is [ROOT, USER]", () => {
      const userRoles = [Enums.UserApplicationRole.UserApplicationRoleEnum.root, Enums.UserApplicationRole.UserApplicationRoleEnum.user];
      expect(PermissionUtil.isNoPermission(userRoles)).toBeTruthy();
    });

    it("should return true when user is [ADMIN, USER]", () => {
      const userRoles = [Enums.UserApplicationRole.UserApplicationRoleEnum.admin, Enums.UserApplicationRole.UserApplicationRoleEnum.user];
      expect(PermissionUtil.isNoPermission(userRoles)).toBeTruthy();
    });

    it("should return true when user is [GUEST, USER]", () => {
      const userRoles = [Enums.UserApplicationRole.UserApplicationRoleEnum.guest, Enums.UserApplicationRole.UserApplicationRoleEnum.user];
      expect(PermissionUtil.isNoPermission(userRoles)).toBeTruthy();
    });
  });
});
