import {
  isNullOrUndefined,
  isNumber,
  StringUtil,
} from "solidify-frontend";

export class FileUtil {
  static transformFileSize(size: number): string {
    if (isNullOrUndefined(size) || !isNumber(size)) {
      return StringUtil.stringEmpty;
    }
    let extension: string;
    let newSize: number;
    if (size < 1024) {
      newSize = size;
      extension = " B";
    } else if (size < (1024 * 1024)) {
      newSize = size / 1024;
      extension = " KB";
    } else if (size < (1024 * 1024 * 1024)) {
      newSize = size / (1024 * 1024);
      extension = " MB";
    } else if (size < (1024 * 1024 * 1024 * 1024)) {
      newSize = size / (1024 * 1024 * 1024);
      extension = " GB";
    } else {
      newSize = size / (1024 * 1024 * 1024 * 1024);
      extension = " TB";
    }
    return newSize.toFixed(1) + extension;
  }
}
