import {environment} from "@environments/environment";
import {versions} from "@environments/versions";
import {isNullOrUndefined} from "solidify-frontend";

export class AppUtil {
  static getVersions(): string {
    if (isNullOrUndefined(versions)) {
      return "not defined";
    }
    if (environment.isDemoMode || !environment.production) {
      return `${versions.version} - ${versions.branch} - ${versions.revision}`;
    }
    return `${versions.version} - ${versions.revision}`;
  }
}
