import {FileInput} from "@shared/filevisualizer/models/file-info.model";
import {LocalStateEnum} from "../../enums/local-state.enum";

const state = LocalStateEnum.shared_visualization;

export namespace SharedVisualizationAction {

  export class Download {
    static readonly type: string = `[${state}] Download`;

    constructor(public data: FileInput,
                public blobId: number) {
    }
  }

  export class DownloadSuccess {
    static readonly type: string = `[${state}] Download success`;

    constructor(public blob: Blob,
                public blobId: number) {
    }
  }

  export class DownloadFailed {
    static readonly type: string = `[${state}] Download failed`;
  }
}

