import {Injectable} from "@angular/core";
import {AdminResourceApiEnum} from "@app/shared/enums/api.enum";
import {sharedSubmissionPolicyActionNameSpace} from "@app/shared/stores/submission-policy/shared-submission-policy.action";
import {SubmissionPolicy} from "@models";
import {
  Actions,
  State,
  Store,
} from "@ngxs/store";
import {
  ApiService,
  defaultResourceStateInitValue,
  NotificationService,
  OrderEnum,
  QueryParameters,
  ResourceState,
  ResourceStateModel,
} from "solidify-frontend";
import {environment} from "../../../../environments/environment";
import {LocalStateEnum} from "../../enums/local-state.enum";

export interface SharedSubmissionPolicyStateModel extends ResourceStateModel<SubmissionPolicy> {
}

@Injectable()
@State<SharedSubmissionPolicyStateModel>({
  name: LocalStateEnum.shared_submissionPolicy,
  defaults: {
    ...defaultResourceStateInitValue(),
    queryParameters: new QueryParameters(environment.defaultEnumValuePageSizeOption, {
      field: "name",
      order: OrderEnum.ascending,
    }),
  },
})
export class SharedSubmissionPolicyState extends ResourceState<SharedSubmissionPolicyStateModel, SubmissionPolicy> {
  constructor(protected apiService: ApiService,
              protected store: Store,
              protected notificationService: NotificationService,
              protected actions$: Actions) {
    super(apiService, store, notificationService, actions$, {
      nameSpace: sharedSubmissionPolicyActionNameSpace,
    });
  }

  protected get _urlResource(): string {
    return AdminResourceApiEnum.submissionPolicies;
  }
}
