import {StatusHistory} from "@shared/models/status-history.model";
import {StatusHistoryNamespace} from "@shared/stores/status-history/status-history-namespace.model";
import {
  BaseAction,
  BaseSubAction,
  CollectionTyped,
  QueryParameters,
} from "solidify-frontend";

export namespace StatusHistoryAction {
  export class History extends BaseAction {
    static readonly type: string = `[{0}] History`;

    constructor(public id: string, public parentId?: string, public queryParameters?: QueryParameters) {
      super();
    }
  }

  export class HistorySuccess extends BaseSubAction<History> {
    static readonly type: string = `[{0}] History Success`;

    constructor(public parentAction: History, public list: CollectionTyped<StatusHistory>) {
      super(parentAction);
    }
  }

  export class HistoryFail extends BaseSubAction<History> {
    static readonly type: string = `[{0}] History Fail`;
  }

  export class ChangeQueryParameters extends BaseAction {
    static readonly type: string = "[{0}] Change Query Parameters";

    constructor(public queryParameters: QueryParameters, public id: string, public parentId?: string) {
      super();
    }
  }
}

export const statusHistoryNamespace: StatusHistoryNamespace | any = StatusHistoryAction;
