import {Injectable} from "@angular/core";
import {SharedInstitutionAction} from "@app/shared/stores/institution/shared-institution.action";
import {
  SharedInstitutionState,
  SharedInstitutionStateModel,
} from "@app/shared/stores/institution/shared-institution.state";
import {SharedLanguageAction} from "@app/shared/stores/language/shared-language.action";
import {
  SharedLanguageState,
  SharedLanguageStateModel,
} from "@app/shared/stores/language/shared-language.state";
import {SharedLicenseAction} from "@app/shared/stores/license/shared-license.action";
import {
  SharedLicenseState,
  SharedLicenseStateModel,
} from "@app/shared/stores/license/shared-license.state";
import {
  SharedOrganizationalUnitState,
  SharedOrganizationalUnitStateModel,
} from "@app/shared/stores/organizational-unit/shared-organizational-unit.state";
import {SharedPersonAction} from "@app/shared/stores/person/shared-person.action";
import {
  SharedPersonState,
  SharedPersonStateModel,
} from "@app/shared/stores/person/shared-person.state";
import {SharedPreservationPolicyAction} from "@app/shared/stores/preservation-policy/shared-preservation-policy.action";
import {
  SharedPreservationPolicyState,
  SharedPreservationPolicyStateModel,
} from "@app/shared/stores/preservation-policy/shared-preservation-policy.state";
import {SharedAction} from "@app/shared/stores/shared.action";
import {SharedSubmissionPolicyAction} from "@app/shared/stores/submission-policy/shared-submission-policy.action";
import {
  SharedSubmissionPolicyState,
  SharedSubmissionPolicyStateModel,
} from "@app/shared/stores/submission-policy/shared-submission-policy.state";
import {
  Action,
  Actions,
  ofActionCompleted,
  State,
  StateContext,
} from "@ngxs/store";
import {LocalStateEnum} from "@shared/enums/local-state.enum";
import {SharedAipState} from "@shared/features/aip/stores/shared-aip.state";
import {
  SharedArchiveAclState,
  SharedArchiveAclStateModel,
} from "@shared/stores/archive-acl/shared-archive-acl.state";
import {
  SharedArchiveState,
  SharedArchiveStateModel,
} from "@shared/stores/archive/shared-archive.state";
import {SharedContributorState} from "@shared/stores/contributor/shared-contributor.state";
import {
  SharedDepositState,
  SharedDepositStateModel,
} from "@shared/stores/deposit/shared-deposit.state";
import {SharedDisseminationPolicyAction} from "@shared/stores/dissemination-policy/shared-dissemination-policy.action";
import {
  SharedDisseminationPolicyState,
  SharedDisseminationPolicyStateModel,
} from "@shared/stores/dissemination-policy/shared-dissemination-policy.state";
import {SharedFundingAgencyAction} from "@shared/stores/funding-agency/shared-funding-agency.action";
import {
  SharedFundingAgencyState,
  SharedFundingAgencyStateModel,
} from "@shared/stores/funding-agency/shared-funding-agency.state";
import {
  SharedIndexFieldAliasState,
  SharedIndexFieldAliasStateModel,
} from "@shared/stores/index-field-alias/shared-index-field-alias.state";
import {SharedMetadataTypeState} from "@shared/stores/metadata-type/shared-metadata-type.state";
import {
  SharedNotificationState,
  SharedNotificationStateModel,
} from "@shared/stores/notification/shared-notification.state";
import {SharedOaiSetState} from "@shared/stores/oai-set/shared-oai-set.state";
import {SharedOauth2ClientState} from "@shared/stores/oauth-2-client/shared-oauth-2-client.state";
import {SharedOrderState} from "@shared/stores/order/shared-order.state";
import {SharedResearchDomainAction} from "@shared/stores/research-domain/shared-research-domain.action";
import {
  SharedResearchDomainState,
  SharedResearchDomainStateModel,
} from "@shared/stores/research-domain/shared-research-domain.state";
import {SharedRoleAction} from "@shared/stores/role/shared-role.action";
import {
  SharedRoleState,
  SharedRoleStateModel,
} from "@shared/stores/role/shared-role.state";
import {SharedUserState} from "@shared/stores/user/shared-user.state";
import {
  SharedVisualizationState,
  SharedVisualizationStateModel,
} from "@shared/stores/visualization/shared-visualization-state.service";
import {Observable} from "rxjs";
import {tap} from "rxjs/operators";
import {
  BaseStateModel,
  StoreUtil,
} from "solidify-frontend";

export interface SharedStateModel extends BaseStateModel {
  shared_organizationalUnit: SharedOrganizationalUnitStateModel;
  shared_deposit: SharedDepositStateModel;
  shared_language: SharedLanguageStateModel;
  shared_license: SharedLicenseStateModel;
  shared_submissionPolicy: SharedSubmissionPolicyStateModel;
  shared_preservationPolicy: SharedPreservationPolicyStateModel;
  shared_disseminationPolicy: SharedDisseminationPolicyStateModel;
  shared_person: SharedPersonStateModel;
  shared_institution: SharedInstitutionStateModel;
  shared_role: SharedRoleStateModel;
  shared_visualization: SharedVisualizationStateModel;
  shared_fundingAgency: SharedFundingAgencyStateModel;
  shared_researchDomain: SharedResearchDomainStateModel;
  shared_notification: SharedNotificationStateModel;
  [LocalStateEnum.shared_archive]: SharedArchiveStateModel;
  [LocalStateEnum.shared_archiveAcl]: SharedArchiveAclStateModel;
  [LocalStateEnum.shared_indexFieldAlias]: SharedIndexFieldAliasStateModel;
}

@Injectable()
@State<SharedStateModel>({
  name: LocalStateEnum.shared,
  defaults: {
    isLoadingCounter: 0,
    shared_organizationalUnit: null,
    shared_deposit: null,
    shared_language: null,
    shared_license: null,
    shared_preservationPolicy: null,
    shared_submissionPolicy: null,
    shared_disseminationPolicy: null,
    shared_person: null,
    shared_institution: null,
    shared_role: null,
    shared_fundingAgency: null,
    shared_visualization: null,
    shared_researchDomain: null,
    shared_notification: null,
    [LocalStateEnum.shared_archive]: null,
    [LocalStateEnum.shared_archiveAcl]: null,
    [LocalStateEnum.shared_indexFieldAlias]: null,
  },
  children: [
    SharedArchiveAclState,
    SharedOrganizationalUnitState,
    SharedDepositState,
    SharedLanguageState,
    SharedLicenseState,
    SharedSubmissionPolicyState,
    SharedPreservationPolicyState,
    SharedDisseminationPolicyState,
    SharedPersonState,
    SharedInstitutionState,
    SharedRoleState,
    SharedFundingAgencyState,
    SharedVisualizationState,
    SharedResearchDomainState,
    SharedNotificationState,
    SharedOauth2ClientState,
    SharedUserState,
    SharedContributorState,
    SharedOrderState,
    SharedOaiSetState,
    SharedMetadataTypeState,
    SharedAipState,
    SharedArchiveState,
    SharedIndexFieldAliasState,
  ],
})
export class SharedState {

  constructor(private actions$: Actions) {
  }
}



