import {Injectable} from "@angular/core";
import {AdminResourceApiEnum} from "@app/shared/enums/api.enum";
import {LocalStateEnum} from "@app/shared/enums/local-state.enum";
import {Role} from "@models";
import {
  Actions,
  State,
  Store,
} from "@ngxs/store";
import {sharedRoleActionNameSpace} from "@shared/stores/role/shared-role.action";
import {
  ApiService,
  defaultResourceStateInitValue,
  NotificationService,
  OrderEnum,
  QueryParameters,
  ResourceState,
  ResourceStateModel,
  Sort,
} from "solidify-frontend";
import {environment} from "../../../../environments/environment";

export interface SharedRoleStateModel extends ResourceStateModel<Role> {
}

@Injectable()
@State<SharedRoleStateModel>({
  name: LocalStateEnum.shared_role,
  defaults: {
    ...defaultResourceStateInitValue(),
    queryParameters: new QueryParameters(environment.defaultEnumValuePageSizeOption, {field: "level", order: OrderEnum.ascending} as Sort),
  },
})
export class SharedRoleState extends ResourceState<SharedRoleStateModel, Role> {
  constructor(protected apiService: ApiService,
              protected store: Store,
              protected notificationService: NotificationService,
              protected actions$: Actions) {
    super(apiService, store, notificationService, actions$, {
      nameSpace: sharedRoleActionNameSpace,
    });
  }

  protected get _urlResource(): string {
    return AdminResourceApiEnum.roles;
  }
}

