import {ResourceLogoNameSpace} from "@shared/stores/resource-logo/resource-logo-namespace.model";
import {
  BaseAction,
  BaseSubAction,
} from "solidify-frontend";

export namespace ResourceLogoAction {
  export class GetPhoto extends BaseAction {
    static readonly type: string = `[{0}] Get Photo`;

    constructor(public resId: string) {
      super();
    }
  }

  export class GetPhotoSuccess extends BaseSubAction<GetPhoto> {
    static readonly type: string = `[{0}] Get Photo Success`;

    constructor(public parentAction: GetPhoto, public blob: Blob) {
      super(parentAction);
    }
  }

  export class GetPhotoFail extends BaseSubAction<GetPhoto> {
    static readonly type: string = `[{0}] Get Photo Fail`;
  }

  export class GetPhotoByResId extends BaseAction {
    static readonly type: string = `[{0}] Get Photo By ResId`;

    constructor(public resId: string) {
      super();
    }
  }

  export class GetPhotoByResIdSuccess extends BaseSubAction<GetPhotoByResId> {
    static readonly type: string = `[{0}] Get Photo By ResId Success`;

    constructor(public parentAction: GetPhotoByResId, public blob: Blob) {
      super(parentAction);
    }
  }

  export class GetPhotoByResIdFail extends BaseSubAction<GetPhotoByResId> {
    static readonly type: string = `[{0}] Get Photo By ResId Fail`;

    constructor(public parentAction: GetPhotoByResId) {
      super(parentAction);
    }
  }

  export class UploadPhoto extends BaseAction {
    static readonly type: string = `[{0}] Upload Photo`;

    constructor(public resId: string, public file: File) {
      super();
    }
  }

  export class UploadPhotoSuccess extends BaseSubAction<UploadPhoto> {
    static readonly type: string = `[{0}] Upload Photo Success`;

    constructor(public parentAction: UploadPhoto) {
      super(parentAction);
    }
  }

  export class UploadPhotoFail extends BaseSubAction<UploadPhoto> {
    static readonly type: string = `[{0}] Upload Photo Fail`;
  }

  export class DeletePhoto extends BaseAction {
    static readonly type: string = `[{0}] Delete Photo`;

    constructor(public resId: string, public file: File) {
      super();
    }
  }

  export class DeletePhotoSuccess extends BaseSubAction<DeletePhoto> {
    static readonly type: string = `[{0}] Delete Photo Success`;

    constructor(public parentAction: DeletePhoto) {
      super(parentAction);
    }
  }

  export class DeletePhotoFail extends BaseSubAction<DeletePhoto> {
    static readonly type: string = `[{0}] Delete Photo Fail`;
  }
}

export const resourceLogoActionNameSpace: ResourceLogoNameSpace | any = ResourceLogoAction;
