import {ResourceLogoNameSpace} from "@shared/stores/resource-logo/resource-logo-namespace.model";
import {ResourceLogoAction} from "@shared/stores/resource-logo/resource-logo.action";
import {ResourceActionHelper} from "solidify-frontend";

export class ResourceLogoActionHelper extends ResourceActionHelper {
  static getPhoto(resourceLogoNameSpace: ResourceLogoNameSpace, ...args: ConstructorParameters<typeof ResourceLogoAction.GetPhoto>): ResourceLogoAction.GetPhoto {
    return new resourceLogoNameSpace.GetPhoto(...args);
  }

  static getPhotoSuccess(resourceLogoNameSpace: ResourceLogoNameSpace, ...args: ConstructorParameters<typeof ResourceLogoAction.GetPhotoSuccess>): ResourceLogoAction.GetPhotoSuccess {
    return new resourceLogoNameSpace.GetPhotoSuccess(...args);
  }

  static getPhotoFail(resourceLogoNameSpace: ResourceLogoNameSpace, ...args: ConstructorParameters<typeof ResourceLogoAction.GetPhotoFail>): ResourceLogoAction.GetPhotoFail {
    return new resourceLogoNameSpace.GetPhotoFail(...args);
  }

  static getPhotoByResId(resourceLogoNameSpace: ResourceLogoNameSpace, ...args: ConstructorParameters<typeof ResourceLogoAction.GetPhotoByResId>): ResourceLogoAction.GetPhotoByResId {
    return new resourceLogoNameSpace.GetPhotoByResId(...args);
  }

  static getPhotoByResIdSuccess(resourceLogoNameSpace: ResourceLogoNameSpace, ...args: ConstructorParameters<typeof ResourceLogoAction.GetPhotoByResIdSuccess>): ResourceLogoAction.GetPhotoByResIdSuccess {
    return new resourceLogoNameSpace.GetPhotoByResIdSuccess(...args);
  }

  static getPhotoByResIdFail(resourceLogoNameSpace: ResourceLogoNameSpace, ...args: ConstructorParameters<typeof ResourceLogoAction.GetPhotoByResIdFail>): ResourceLogoAction.GetPhotoByResIdFail {
    return new resourceLogoNameSpace.GetPhotoByResIdFail(...args);
  }

  static deletePhoto(resourceLogoNameSpace: ResourceLogoNameSpace, ...args: ConstructorParameters<typeof ResourceLogoAction.DeletePhoto>): ResourceLogoAction.DeletePhoto {
    return new resourceLogoNameSpace.DeletePhoto(...args);
  }

  static deletePhotoSuccess(resourceLogoNameSpace: ResourceLogoNameSpace, ...args: ConstructorParameters<typeof ResourceLogoAction.DeletePhotoSuccess>): ResourceLogoAction.DeletePhotoSuccess {
    return new resourceLogoNameSpace.DeletePhotoSuccess(...args);
  }

  static deletePhotoFail(resourceLogoNameSpace: ResourceLogoNameSpace, ...args: ConstructorParameters<typeof ResourceLogoAction.DeletePhotoFail>): ResourceLogoAction.DeletePhotoFail {
    return new resourceLogoNameSpace.DeletePhotoFail(...args);
  }

  static uploadPhoto(resourceLogoNameSpace: ResourceLogoNameSpace, ...args: ConstructorParameters<typeof ResourceLogoAction.UploadPhoto>): ResourceLogoAction.UploadPhoto {
    return new resourceLogoNameSpace.UploadPhoto(...args);
  }

  static uploadPhotoSuccess(resourceLogoNameSpace: ResourceLogoNameSpace, ...args: ConstructorParameters<typeof ResourceLogoAction.UploadPhotoSuccess>): ResourceLogoAction.UploadPhotoSuccess {
    return new resourceLogoNameSpace.UploadPhotoSuccess(...args);
  }

  static uploadPhotoFail(resourceLogoNameSpace: ResourceLogoNameSpace, ...args: ConstructorParameters<typeof ResourceLogoAction.UploadPhotoFail>): ResourceLogoAction.UploadPhotoFail {
    return new resourceLogoNameSpace.UploadPhotoFail(...args);
  }
}
