import {Injectable} from "@angular/core";
import {AdminResourceApiEnum} from "@app/shared/enums/api.enum";
import {sharedPreservationPolicyActionNameSpace} from "@app/shared/stores/preservation-policy/shared-preservation-policy.action";
import {environment} from "@environments/environment";
import {PreservationPolicy} from "@models";
import {
  Actions,
  State,
  Store,
} from "@ngxs/store";
import {
  ApiService,
  defaultResourceStateInitValue,
  NotificationService,
  OrderEnum,
  QueryParameters,
  ResourceState,
  ResourceStateModel,
} from "solidify-frontend";
import {LocalStateEnum} from "../../enums/local-state.enum";

export interface SharedPreservationPolicyStateModel extends ResourceStateModel<PreservationPolicy> {
}

@Injectable()
@State<SharedPreservationPolicyStateModel>({
  name: LocalStateEnum.shared_preservationPolicy,
  defaults: {
    ...defaultResourceStateInitValue(),
    queryParameters: new QueryParameters(environment.defaultEnumValuePageSizeOption, {
      field: "name",
      order: OrderEnum.ascending,
    }),
  },
})
export class SharedPreservationPolicyState extends ResourceState<SharedPreservationPolicyStateModel, PreservationPolicy> {
  constructor(protected apiService: ApiService,
              protected store: Store,
              protected notificationService: NotificationService,
              protected actions$: Actions) {
    super(apiService, store, notificationService, actions$, {
      nameSpace: sharedPreservationPolicyActionNameSpace,
    });
  }

  protected get _urlResource(): string {
    return AdminResourceApiEnum.preservationPolicies;
  }
}
