import {
  Institution,
  Person,
} from "@models";
import {
  BaseAction,
  BaseSubAction,
  QueryParameters,
  ResourceAction,
  ResourceNameSpace,
  TypeDefaultAction,
} from "solidify-frontend";
import {LocalStateEnum} from "../../enums/local-state.enum";

const state = LocalStateEnum.shared_person;

export namespace SharedPersonAction {
  @TypeDefaultAction(state)
  export class LoadResource extends ResourceAction.LoadResource {
  }

  @TypeDefaultAction(state)
  export class LoadResourceSuccess extends ResourceAction.LoadResourceSuccess {
  }

  @TypeDefaultAction(state)
  export class LoadResourceFail extends ResourceAction.LoadResourceFail {
  }

  @TypeDefaultAction(state)
  export class ChangeQueryParameters extends ResourceAction.ChangeQueryParameters {
  }

  @TypeDefaultAction(state)
  export class GetAll extends ResourceAction.GetAll {
    constructor(public queryParameters?: QueryParameters, public keepCurrentContext: boolean = false, public cancelIncomplete: boolean = true, public onlyWithUser: boolean = false) {
      super();
    }
  }

  @TypeDefaultAction(state)
  export class GetAllSuccess extends ResourceAction.GetAllSuccess<Person> {
  }

  @TypeDefaultAction(state)
  export class GetAllFail extends ResourceAction.GetAllFail<Person> {
  }

  @TypeDefaultAction(state)
  export class GetByListId extends ResourceAction.GetByListId {
  }

  @TypeDefaultAction(state)
  export class GetByListIdSuccess extends ResourceAction.GetByListIdSuccess {
  }

  @TypeDefaultAction(state)
  export class GetByListIdFail extends ResourceAction.GetByListIdFail {
  }

  @TypeDefaultAction(state)
  export class GetById extends ResourceAction.GetById {
  }

  @TypeDefaultAction(state)
  export class GetByIdSuccess extends ResourceAction.GetByIdSuccess<Person> {
  }

  @TypeDefaultAction(state)
  export class GetByIdFail extends ResourceAction.GetByIdFail<Person> {
  }

  @TypeDefaultAction(state)
  export class Create extends ResourceAction.Create<Person> {
  }

  @TypeDefaultAction(state)
  export class CreateSuccess extends ResourceAction.CreateSuccess<Person> {
  }

  @TypeDefaultAction(state)
  export class CreateFail extends ResourceAction.CreateFail<Person> {
  }

  @TypeDefaultAction(state)
  export class Update extends ResourceAction.Update<Person> {
  }

  @TypeDefaultAction(state)
  export class UpdateSuccess extends ResourceAction.UpdateSuccess<Person> {
  }

  @TypeDefaultAction(state)
  export class UpdateFail extends ResourceAction.UpdateFail<Person> {
  }

  @TypeDefaultAction(state)
  export class Delete extends ResourceAction.Delete {
  }

  @TypeDefaultAction(state)
  export class DeleteSuccess extends ResourceAction.DeleteSuccess {
  }

  @TypeDefaultAction(state)
  export class DeleteFail extends ResourceAction.DeleteFail {
  }

  @TypeDefaultAction(state)
  export class AddInList extends ResourceAction.AddInList<Person> {
  }

  @TypeDefaultAction(state)
  export class AddInListById extends ResourceAction.AddInListById {
  }

  @TypeDefaultAction(state)
  export class AddInListByIdSuccess extends ResourceAction.AddInListByIdSuccess<Person> {
  }

  @TypeDefaultAction(state)
  export class AddInListByIdFail extends ResourceAction.AddInListByIdFail<Person> {
  }

  @TypeDefaultAction(state)
  export class RemoveInListById extends ResourceAction.RemoveInListById {
  }

  @TypeDefaultAction(state)
  export class RemoveInListByListId extends ResourceAction.RemoveInListByListId {
  }

  @TypeDefaultAction(state)
  export class LoadNextChunkList extends ResourceAction.LoadNextChunkList {
  }

  @TypeDefaultAction(state)
  export class LoadNextChunkListSuccess extends ResourceAction.LoadNextChunkListSuccess<Person> {
  }

  @TypeDefaultAction(state)
  export class LoadNextChunkListFail extends ResourceAction.LoadNextChunkListFail {
  }

  @TypeDefaultAction(state)
  export class Clean extends ResourceAction.Clean {
  }

  export class Search extends BaseAction {
    static readonly type: string = `[${state}] Search`;

    constructor(public person: Person) {
      super();
    }
  }

  export class SearchSuccess extends BaseSubAction<Search> {
    static readonly type: string = `[${state}] Search Success`;
  }

  export class SearchFail extends BaseSubAction<Search> {
    static readonly type: string = `[${state}] Search Fail`;
  }

  export class SearchPerson extends BaseAction {
    static readonly type: string = `[${state}] Search Person`;

    constructor(public person: Person) {
      super();
    }
  }

  export class SearchPersonSuccess extends BaseSubAction<SearchPerson> {
    static readonly type: string = `[${state}] Search Person Success`;

    constructor(public parentAction: SearchPerson, public list: Person[]) {
      super(parentAction);
    }
  }

  export class SearchPersonFail extends BaseSubAction<SearchPerson> {
    static readonly type: string = `[${state}] Search Person Fail`;
  }

  export class SearchInstitutions extends BaseAction {
    static readonly type: string = `[${state}] Search Institutions`;
  }

  export class SearchInstitutionsSuccess extends BaseSubAction<SearchInstitutions> {
    static readonly type: string = `[${state}] Search Institutions Success`;
  }

  export class SearchInstitutionsFail extends BaseSubAction<SearchInstitutions> {
    static readonly type: string = `[${state}] Search Institutions Fail`;
  }

  export class SearchPersonInstitution extends BaseAction {
    static readonly type: string = `[${state}] Search Person Institution`;

    constructor(public person: Person) {
      super();
    }
  }

  export class SearchPersonInstitutionSuccess extends BaseSubAction<SearchPersonInstitution> {
    static readonly type: string = `[${state}] Search Person Institution Success`;

    constructor(public parentAction: SearchPersonInstitution, public person: Person, public institutions: Institution[]) {
      super(parentAction);
    }
  }

  export class SearchPersonInstitutionFail extends BaseSubAction<SearchPersonInstitution> {
    static readonly type: string = `[${state}] Search Person Institution Fail`;
  }
}

export const sharedPersonActionNameSpace: ResourceNameSpace = SharedPersonAction;
