import {OrganizationalUnitSubmissionPolicy} from "@admin/models/organizational-unit-submission-policy.model";
import {Injectable} from "@angular/core";
import {ApiResourceNameEnum} from "@app/shared/enums/api-resource-name.enum";
import {AdminResourceApiEnum} from "@app/shared/enums/api.enum";
import {LocalStateEnum} from "@app/shared/enums/local-state.enum";
import {SubmissionPolicy} from "@models";
import {
  Action,
  Actions,
  State,
  StateContext,
  Store,
} from "@ngxs/store";
import {
  SharedOrgUnitSubmissionPolicyAction,
  sharedOrgUnitSubmissionPolicyStateNamespace,
} from "@shared/stores/organizational-unit/submission-policy/shared-organizational-unit-submission-policy.action";
import {
  ApiService,
  defaultRelation2TiersStateInitValue,
  NotificationService,
  Relation2TiersState,
  Relation2TiersStateModel,
} from "solidify-frontend";

export interface SharedOrganizationalUnitSubmissionPolicyStateModel extends Relation2TiersStateModel<SubmissionPolicy> {
}

@Injectable()
@State<SharedOrganizationalUnitSubmissionPolicyStateModel>({
  name: LocalStateEnum.shared_organizationalUnit_submissionPolicy,
  defaults: {
    ...defaultRelation2TiersStateInitValue(),
  },
})
export class SharedOrganizationalUnitSubmissionPolicyState extends Relation2TiersState<SharedOrganizationalUnitSubmissionPolicyStateModel, SubmissionPolicy, OrganizationalUnitSubmissionPolicy> {
  constructor(protected apiService: ApiService,
              protected store: Store,
              protected notificationService: NotificationService,
              protected actions$: Actions) {
    super(apiService, store, notificationService, actions$, {
      nameSpace: sharedOrgUnitSubmissionPolicyStateNamespace,
      resourceName: ApiResourceNameEnum.SUB_POLICY,
    });
  }

  protected get _urlResource(): string {
    return AdminResourceApiEnum.organizationalUnits;
  }

  @Action(SharedOrgUnitSubmissionPolicyAction.Clear)
  clear(ctx: StateContext<SharedOrganizationalUnitSubmissionPolicyStateModel>, action: SharedOrgUnitSubmissionPolicyAction.Clear): void {
    ctx.patchState({
      selected: null,
    });
  }
}
