import {Injectable} from "@angular/core";
import {
  AccessResourceApiEnum,
  AdminResourceApiEnum,
} from "@app/shared/enums/api.enum";
import {
  sharedOrganizationalUnitActionNameSpace,
  SharedOrgUnitAction,
} from "@app/shared/stores/organizational-unit/shared-organizational-unit.action";
import {environment} from "@environments/environment";
import {OrganizationalUnit} from "@models";
import {
  Action,
  Actions,
  State,
  StateContext,
  Store,
} from "@ngxs/store";
import {LocalStateModel} from "@shared/models/local-state.model";
import {
  SharedOrganizationalUnitDisseminationPolicyState,
  SharedOrganizationalUnitDisseminationPolicyStateModel,
} from "@shared/stores/organizational-unit/dissemination-policy/shared-organizational.unit-dissemination-policy.state";
import {
  SharedOrganizationalUnitPreservationPolicyState,
  SharedOrganizationalUnitPreservationPolicyStateModel,
} from "@shared/stores/organizational-unit/preservation-policy/shared-organizational-unit-preservation-policy.state";
import {
  SharedOrganizationalUnitSubmissionPolicyState,
  SharedOrganizationalUnitSubmissionPolicyStateModel,
} from "@shared/stores/organizational-unit/submission-policy/shared-organizational-unit-submission-policy.state";
import {Observable} from "rxjs";
import {
  ApiService,
  defaultRelation2TiersStateInitValue,
  defaultResourceStateInitValue,
  isNullOrUndefined,
  NotificationService,
  OverrideDefaultAction,
  QueryParameters,
  ResourceState,
  ResourceStateModel,
} from "solidify-frontend";
import {LocalStateEnum} from "../../enums/local-state.enum";

export interface SharedOrganizationalUnitStateModel extends ResourceStateModel<OrganizationalUnit> {
  shared_organizationalUnit_preservationPolicy: SharedOrganizationalUnitPreservationPolicyStateModel;
  shared_organizationalUnit_submissionPolicy: SharedOrganizationalUnitSubmissionPolicyStateModel;
  shared_organizationalUnit_disseminationPolicy: SharedOrganizationalUnitDisseminationPolicyStateModel;
}

@Injectable()
@State<SharedOrganizationalUnitStateModel>({
  name: LocalStateEnum.shared_organizationalUnit,
  defaults: {
    ...defaultResourceStateInitValue(),
    shared_organizationalUnit_preservationPolicy: {...defaultRelation2TiersStateInitValue()},
    shared_organizationalUnit_submissionPolicy: {...defaultRelation2TiersStateInitValue()},
    shared_organizationalUnit_disseminationPolicy: {...defaultRelation2TiersStateInitValue()},
    queryParameters: new QueryParameters(environment.defaultEnumValuePageSizeOption),
  },
  children: [
    SharedOrganizationalUnitPreservationPolicyState,
    SharedOrganizationalUnitSubmissionPolicyState,
    SharedOrganizationalUnitDisseminationPolicyState,
  ],
})
export class SharedOrganizationalUnitState extends ResourceState<SharedOrganizationalUnitStateModel, OrganizationalUnit> {

  constructor(protected apiService: ApiService,
              protected store: Store,
              protected notificationService: NotificationService,
              protected actions$: Actions) {
    super(apiService, store, notificationService, actions$, {
      nameSpace: sharedOrganizationalUnitActionNameSpace,
    });
  }

  protected get _urlResource(): string {
    let isLogged = this.store.selectSnapshot((state: LocalStateModel) => state.application.isLoggedIn) as boolean;
    if (isNullOrUndefined(isLogged)) {
      isLogged = false;
    }
    return isLogged ? AdminResourceApiEnum.organizationalUnits : AccessResourceApiEnum.organizationalUnits;
  }

  @OverrideDefaultAction()
  @Action(SharedOrgUnitAction.GetById)
  getById(ctx: StateContext<SharedOrganizationalUnitStateModel>, action: SharedOrgUnitAction.GetById): Observable<OrganizationalUnit> {
    ctx.patchState({
      isLoadingCounter: ctx.getState().isLoadingCounter + 1,
    });

    return super.getById(ctx, action);
  }

  @OverrideDefaultAction()
  @Action(SharedOrgUnitAction.GetByIdSuccess)
  getByIdSuccess(ctx: StateContext<SharedOrganizationalUnitStateModel>, action: SharedOrgUnitAction.GetByIdSuccess): void {
    super.getByIdSuccess(ctx, action);
    ctx.patchState({
      isLoadingCounter: ctx.getState().isLoadingCounter - 1,
    });
  }

  @OverrideDefaultAction()
  @Action(SharedOrgUnitAction.GetByIdFail)
  getByIdFail(ctx: StateContext<SharedOrganizationalUnitStateModel>, action: SharedOrgUnitAction.GetByIdFail): void {
    super.getByIdFail(ctx, action);
    ctx.patchState({
      isLoadingCounter: ctx.getState().isLoadingCounter - 1,
    });
  }
}
