import {Injectable} from "@angular/core";
import {OrganizationalUnitPreservationPolicy} from "@app/features/admin/models/organizational-unit-preservation-policy.model";
import {ApiResourceNameEnum} from "@app/shared/enums/api-resource-name.enum";
import {AdminResourceApiEnum} from "@app/shared/enums/api.enum";
import {LocalStateEnum} from "@app/shared/enums/local-state.enum";
import {PreservationPolicy} from "@models";
import {
  Action,
  Actions,
  State,
  StateContext,
  Store,
} from "@ngxs/store";
import {
  SharedOrgUnitPreservationPolicyAction,
  sharedOrgUnitPreservationPolicyActionNameSpace,
} from "@shared/stores/organizational-unit/preservation-policy/shared-organizational-unit-preservation-policy.action";
import {
  ApiService,
  defaultRelation2TiersStateInitValue,
  NotificationService,
  Relation2TiersState,
  Relation2TiersStateModel,
} from "solidify-frontend";

export interface SharedOrganizationalUnitPreservationPolicyStateModel extends Relation2TiersStateModel<PreservationPolicy> {
}

@Injectable()
@State<SharedOrganizationalUnitPreservationPolicyStateModel>({
  name: LocalStateEnum.shared_organizationalUnit_preservationPolicy,
  defaults: {
    ...defaultRelation2TiersStateInitValue(),
  },
})
export class SharedOrganizationalUnitPreservationPolicyState extends Relation2TiersState<SharedOrganizationalUnitPreservationPolicyStateModel, PreservationPolicy, OrganizationalUnitPreservationPolicy> {
  constructor(protected apiService: ApiService,
              protected store: Store,
              protected notificationService: NotificationService,
              protected actions$: Actions) {
    super(apiService, store, notificationService, actions$, {
      nameSpace: sharedOrgUnitPreservationPolicyActionNameSpace,
      resourceName: ApiResourceNameEnum.PRES_POLICY,
    });
  }

  protected get _urlResource(): string {
    return AdminResourceApiEnum.organizationalUnits;
  }

  @Action(SharedOrgUnitPreservationPolicyAction.Clear)
  clear(ctx: StateContext<SharedOrganizationalUnitPreservationPolicyStateModel>, action: SharedOrgUnitPreservationPolicyAction.Clear): void {
    ctx.patchState({
      selected: null,
    });
  }
}
