import {OrganizationalUnitDisseminationPolicy} from "@admin/models/organizational-unit-dissemination-policy.model";
import {Injectable} from "@angular/core";
import {ApiResourceNameEnum} from "@app/shared/enums/api-resource-name.enum";
import {AdminResourceApiEnum} from "@app/shared/enums/api.enum";
import {LocalStateEnum} from "@app/shared/enums/local-state.enum";
import {DisseminationPolicy} from "@models";

import {
  Action,
  Actions,
  State,
  StateContext,
  Store,
} from "@ngxs/store";
import {
  SharedOrgUnitDisseminationPolicyAction,
  sharedOrgUnitDisseminationPolicyActionNameSpace,
} from "@shared/stores/organizational-unit/dissemination-policy/shared-organizational-unit-dissemination-policy.action";
import {SharedOrgUnitPreservationPolicyAction} from "@shared/stores/organizational-unit/preservation-policy/shared-organizational-unit-preservation-policy.action";
import {
  ApiService,
  defaultRelation2TiersStateInitValue,
  NotificationService,
  Relation2TiersState,
  Relation2TiersStateModel,
} from "solidify-frontend";

export interface SharedOrganizationalUnitDisseminationPolicyStateModel extends Relation2TiersStateModel<DisseminationPolicy> {
}

@Injectable()
@State<SharedOrganizationalUnitDisseminationPolicyStateModel>({
  name: LocalStateEnum.shared_organizationalUnit_disseminationPolicy,
  defaults: {
    ...defaultRelation2TiersStateInitValue(),
  },
})
export class SharedOrganizationalUnitDisseminationPolicyState extends Relation2TiersState<SharedOrganizationalUnitDisseminationPolicyStateModel, DisseminationPolicy, OrganizationalUnitDisseminationPolicy> {
  constructor(protected apiService: ApiService,
              protected store: Store,
              protected notificationService: NotificationService,
              protected actions$: Actions) {
    super(apiService, store, notificationService, actions$, {
      nameSpace: sharedOrgUnitDisseminationPolicyActionNameSpace,
      resourceName: ApiResourceNameEnum.DISSEMINATION_POLICY,
    });
  }

  protected get _urlResource(): string {
    return AdminResourceApiEnum.organizationalUnits;
  }

  @Action(SharedOrgUnitPreservationPolicyAction.Clear)
  clear(ctx: StateContext<SharedOrganizationalUnitDisseminationPolicyStateModel>, action: SharedOrgUnitDisseminationPolicyAction.Clear): void {
    ctx.patchState({
      selected: null,
    });
  }
}
