import {Injectable} from "@angular/core";
import {AdminResourceApiEnum} from "@app/shared/enums/api.enum";
import {LocalStateEnum} from "@app/shared/enums/local-state.enum";
import {environment} from "@environments/environment";
import {Oauth2Client} from "@models";
import {
  Actions,
  Selector,
  State,
  Store,
} from "@ngxs/store";
import {sharedOauth2ClientActionNameSpace} from "@shared/stores/oauth-2-client/shared-oauth-2-client.action";
import {
  ApiService,
  defaultResourceStateInitValue,
  NotificationService,
  QueryParameters,
  ResourceState,
  ResourceStateModel,
  StoreUtil,
} from "solidify-frontend";

export interface SharedOauth2ClientStateModel extends ResourceStateModel<Oauth2Client> {
}

@Injectable()
@State<SharedOauth2ClientStateModel>({
  name: LocalStateEnum.shared_oauth2Client,
  defaults: {
    ...defaultResourceStateInitValue(),
    queryParameters: new QueryParameters(environment.defaultEnumValuePageSizeOption),
  },
})
export class SharedOauth2ClientState extends ResourceState<SharedOauth2ClientStateModel, Oauth2Client> {
  constructor(protected apiService: ApiService,
              protected store: Store,
              protected notificationService: NotificationService,
              protected actions$: Actions) {
    super(apiService, store, notificationService, actions$, {
      nameSpace: sharedOauth2ClientActionNameSpace,
    });
  }

  protected get _urlResource(): string {
    return AdminResourceApiEnum.oauth2Clients;
  }

  @Selector()
  static isLoading<T>(state: ResourceStateModel<T>): boolean {
    return StoreUtil.isLoadingState(state);
  }
}
