import {Injectable} from "@angular/core";
import {AccessResourceApiEnum} from "@app/shared/enums/api.enum";
import {LocalStateEnum} from "@app/shared/enums/local-state.enum";
import {environment} from "@environments/environment";
import {OaiSet} from "@models";
import {
  Actions,
  Selector,
  State,
  Store,
} from "@ngxs/store";
import {sharedOaiSetActionNameSpace} from "@shared/stores/oai-set/shared-oai-set.action";
import {
  ApiService,
  defaultResourceStateInitValue,
  NotificationService,
  QueryParameters,
  ResourceState,
  ResourceStateModel,
  StoreUtil,
} from "solidify-frontend";

export interface SharedOaiSetStateModel extends ResourceStateModel<OaiSet> {
}

@Injectable()
@State<SharedOaiSetStateModel>({
  name: LocalStateEnum.shared_oaiSet,
  defaults: {
    ...defaultResourceStateInitValue(),
    queryParameters: new QueryParameters(environment.defaultEnumValuePageSizeOption),
  },
})
export class SharedOaiSetState extends ResourceState<SharedOaiSetStateModel, OaiSet> {
  constructor(protected apiService: ApiService,
              protected store: Store,
              protected notificationService: NotificationService,
              protected actions$: Actions) {
    super(apiService, store, notificationService, actions$, {
      nameSpace: sharedOaiSetActionNameSpace,
    });
  }

  protected get _urlResource(): string {
    return AccessResourceApiEnum.oaiSets;
  }

  @Selector()
  static isLoading<T>(state: ResourceStateModel<T>): boolean {
    return StoreUtil.isLoadingState(state);
  }
}
