import {Injectable} from "@angular/core";
import {AdminResourceApiEnum} from "@app/shared/enums/api.enum";
import {LocalStateEnum} from "@app/shared/enums/local-state.enum";
import {environment} from "@environments/environment";
import {NotificationDlcm} from "@models";
import {
  Actions,
  Selector,
  State,
  Store,
} from "@ngxs/store";
import {sharedNotificationActionNameSpace} from "@shared/stores/notification/shared-notification.action";
import {
  ApiService,
  defaultResourceStateInitValue,
  NotificationService,
  QueryParameters,
  ResourceState,
  ResourceStateModel,
  StoreUtil,
  MARK_AS_TRANSLATABLE,
} from "solidify-frontend";

export interface SharedNotificationStateModel extends ResourceStateModel<NotificationDlcm> {
}

@Injectable()
@State<SharedNotificationStateModel>({
  name: LocalStateEnum.shared_notification,
  defaults: {
    ...defaultResourceStateInitValue(),
    queryParameters: new QueryParameters(environment.defaultEnumValuePageSizeOption),
  },
})
export class SharedNotificationState extends ResourceState<SharedNotificationStateModel, NotificationDlcm> {
  constructor(protected apiService: ApiService,
              protected store: Store,
              protected notificationService: NotificationService,
              protected actions$: Actions) {
    super(apiService, store, notificationService, actions$, {
      nameSpace: sharedNotificationActionNameSpace,
      notificationResourceCreateSuccessTextToTranslate: MARK_AS_TRANSLATABLE("notification.notification.requestSendWithSuccess"),
      notificationResourceCreateFailTextToTranslate: MARK_AS_TRANSLATABLE("notification.notification.unableToSendRequest"),
    });
  }

  protected get _urlResource(): string {
    return AdminResourceApiEnum.notifications;
  }

  @Selector()
  static isLoading<T>(state: ResourceStateModel<T>): boolean {
    return StoreUtil.isLoadingState(state);
  }
}
