import {Injectable} from "@angular/core";
import {AdminResourceApiEnum} from "@app/shared/enums/api.enum";
import {LocalStateEnum} from "@app/shared/enums/local-state.enum";
import {environment} from "@environments/environment";
import {MetadataType} from "@models";
import {
  Actions,
  Selector,
  State,
  Store,
} from "@ngxs/store";
import {sharedMetadataTypeActionNameSpace} from "@shared/stores/metadata-type/shared-metadata-type.action";
import {
  ApiService,
  defaultResourceStateInitValue,
  NotificationService,
  QueryParameters,
  ResourceState,
  ResourceStateModel,
  StoreUtil,
} from "solidify-frontend";

export interface SharedMetadataTypeStateModel extends ResourceStateModel<MetadataType> {
}

@Injectable()
@State<SharedMetadataTypeStateModel>({
  name: LocalStateEnum.shared_metadataType,
  defaults: {
    ...defaultResourceStateInitValue(),
    queryParameters: new QueryParameters(environment.defaultEnumValuePageSizeOption),
  },
})
export class SharedMetadataTypeState extends ResourceState<SharedMetadataTypeStateModel, MetadataType> {
  constructor(protected apiService: ApiService,
              protected store: Store,
              protected notificationService: NotificationService,
              protected actions$: Actions) {
    super(apiService, store, notificationService, actions$, {
      nameSpace: sharedMetadataTypeActionNameSpace,
    });
  }

  protected get _urlResource(): string {
    return AdminResourceApiEnum.metadataTypes;
  }

  @Selector()
  static isLoading<T>(state: ResourceStateModel<T>): boolean {
    return StoreUtil.isLoadingState(state);
  }
}
