import {Injectable} from "@angular/core";
import {AdminResourceApiEnum} from "@app/shared/enums/api.enum";
import {LocalStateEnum} from "@app/shared/enums/local-state.enum";
import {sharedLicenseActionNameSpace} from "@app/shared/stores/license/shared-license.action";
import {License} from "@models";
import {
  Actions,
  Selector,
  State,
  Store,
} from "@ngxs/store";
import {
  ApiService,
  defaultResourceStateInitValue,
  NotificationService,
  QueryParameters,
  ResourceState,
  ResourceStateModel,
  StoreUtil,
} from "solidify-frontend";
import {environment} from "../../../../environments/environment";

export interface SharedLicenseStateModel extends ResourceStateModel<License> {
}

@Injectable()
@State<SharedLicenseStateModel>({
  name: LocalStateEnum.shared_license,
  defaults: {
    ...defaultResourceStateInitValue(),
    queryParameters: new QueryParameters(environment.defaultEnumValuePageSizeOption),
  },
})
export class SharedLicenseState extends ResourceState<SharedLicenseStateModel, License> {
  constructor(protected apiService: ApiService,
              protected store: Store,
              protected notificationService: NotificationService,
              protected actions$: Actions) {
    super(apiService, store, notificationService, actions$, {
      nameSpace: sharedLicenseActionNameSpace,
    });
  }

  protected get _urlResource(): string {
    return AdminResourceApiEnum.licenses;
  }

  @Selector()
  static isLoading<T>(state: ResourceStateModel<T>): boolean {
    return StoreUtil.isLoadingState(state);
  }
}
