import {Injectable} from "@angular/core";
import {AdminResourceApiEnum} from "@app/shared/enums/api.enum";
import {sharedLanguageActionNameSpace} from "@app/shared/stores/language/shared-language.action";
import {Language} from "@models";
import {
  Actions,
  State,
  Store,
} from "@ngxs/store";
import {
  ApiService,
  defaultResourceStateInitValue,
  NotificationService,
  QueryParameters,
  ResourceState,
  ResourceStateModel,
} from "solidify-frontend";
import {environment} from "../../../../environments/environment";
import {LocalStateEnum} from "../../enums/local-state.enum";

export interface SharedLanguageStateModel extends ResourceStateModel<Language> {
}

@Injectable()
@State<SharedLanguageStateModel>({
  name: LocalStateEnum.shared_language,
  defaults: {
    ...defaultResourceStateInitValue(),
    queryParameters: new QueryParameters(environment.defaultEnumValuePageSizeOption),
  },
})
export class SharedLanguageState extends ResourceState<SharedLanguageStateModel, Language> {
  constructor(protected apiService: ApiService,
              protected store: Store,
              protected notificationService: NotificationService,
              protected actions$: Actions) {
    super(apiService, store, notificationService, actions$, {
      nameSpace: sharedLanguageActionNameSpace,
    });
  }

  protected get _urlResource(): string {
    return AdminResourceApiEnum.languages;
  }
}
