import {Injectable} from "@angular/core";
import {AdminResourceApiEnum} from "@app/shared/enums/api.enum";
import {LocalStateEnum} from "@app/shared/enums/local-state.enum";
import {sharedInstitutionActionNameSpace} from "@app/shared/stores/institution/shared-institution.action";
import {Institution} from "@models";
import {
  Actions,
  State,
  Store,
} from "@ngxs/store";
import {
  ApiService,
  defaultResourceStateInitValue,
  NotificationService,
  QueryParameters,
  ResourceState,
  ResourceStateModel,
} from "solidify-frontend";
import {environment} from "../../../../environments/environment";

export interface SharedInstitutionStateModel extends ResourceStateModel<Institution> {
}

@Injectable()
@State<SharedInstitutionStateModel>({
  name: LocalStateEnum.shared_institution,
  defaults: {
    ...defaultResourceStateInitValue(),
    queryParameters: new QueryParameters(environment.defaultEnumValuePageSizeOption),
  },
})
export class SharedInstitutionState extends ResourceState<SharedInstitutionStateModel, Institution> {
  constructor(protected apiService: ApiService,
              protected store: Store,
              protected notificationService: NotificationService,
              protected actions$: Actions) {
    super(apiService, store, notificationService, actions$, {
      nameSpace: sharedInstitutionActionNameSpace,
    });
  }

  protected get _urlResource(): string {
    return AdminResourceApiEnum.institutions;
  }
}
