import {Injectable} from "@angular/core";
import {DataManagementResourceApiEnum} from "@app/shared/enums/api.enum";
import {LocalStateEnum} from "@app/shared/enums/local-state.enum";
import {environment} from "@environments/environment";
import {IndexFieldAlias} from "@models";
import {
  Actions,
  State,
  Store,
} from "@ngxs/store";
import {sharedIndexFieldAliasActionNameSpace} from "@shared/stores/index-field-alias/shared-index-field-alias.action";
import {
  ApiService,
  defaultResourceStateInitValue,
  NotificationService,
  QueryParameters,
  ResourceState,
  ResourceStateModel,
} from "solidify-frontend";

export interface SharedIndexFieldAliasStateModel extends ResourceStateModel<IndexFieldAlias> {
}

@Injectable()
@State<SharedIndexFieldAliasStateModel>({
  name: LocalStateEnum.shared_indexFieldAlias,
  defaults: {
    ...defaultResourceStateInitValue(),
    queryParameters: new QueryParameters(environment.defaultEnumValuePageSizeOption),
  },
})
export class SharedIndexFieldAliasState extends ResourceState<SharedIndexFieldAliasStateModel, IndexFieldAlias> {
  constructor(protected apiService: ApiService,
              protected store: Store,
              protected notificationService: NotificationService,
              protected actions$: Actions) {
    super(apiService, store, notificationService, actions$, {
      nameSpace: sharedIndexFieldAliasActionNameSpace,
    });
  }

  protected get _urlResource(): string {
    return DataManagementResourceApiEnum.indexFieldAliases;
  }
}
