import {Injectable} from "@angular/core";
import {AdminResourceApiEnum} from "@app/shared/enums/api.enum";
import {LocalStateEnum} from "@app/shared/enums/local-state.enum";
import {FundingAgency} from "@models";
import {
  Actions,
  State,
  Store,
} from "@ngxs/store";
import {sharedFundingAgencyActionNameSpace} from "@shared/stores/funding-agency/shared-funding-agency.action";
import {
  ApiService,
  defaultResourceStateInitValue,
  NotificationService,
  QueryParameters,
  ResourceState,
  ResourceStateModel,
} from "solidify-frontend";
import {environment} from "../../../../environments/environment";

export interface SharedFundingAgencyStateModel extends ResourceStateModel<FundingAgency> {
}

@Injectable()
@State<SharedFundingAgencyStateModel>({
  name: LocalStateEnum.shared_fundingAgency,
  defaults: {
    ...defaultResourceStateInitValue(),
    queryParameters: new QueryParameters(environment.defaultEnumValuePageSizeOption),
  },
})
export class SharedFundingAgencyState extends ResourceState<SharedFundingAgencyStateModel, FundingAgency> {
  constructor(protected apiService: ApiService,
              protected store: Store,
              protected notificationService: NotificationService,
              protected actions$: Actions) {
    super(apiService, store, notificationService, actions$, {
      nameSpace: sharedFundingAgencyActionNameSpace,
    });
  }

  protected get _urlResource(): string {
    return AdminResourceApiEnum.fundingAgencies;
  }
}
