import {StatusHistory} from "@shared/models/status-history.model";
import {DlcmResourceNameSpace} from "@shared/stores/dlcm-resource/dlcm-resource-namespace.model";
import {
  BaseAction,
  BaseSubAction,
  CollectionTyped,
} from "solidify-frontend";

export namespace DlcmResourceAction {
  export class History extends BaseAction {
    static readonly type: string = `[{0}] History`;

    constructor(public id: string) {
      super();
    }
  }

  export class HistorySuccess extends BaseSubAction<History> {
    static readonly type: string = `[{0}] History Success`;

    constructor(public parentAction: History, public list: CollectionTyped<StatusHistory>) {
      super(parentAction);
    }
  }

  export class HistoryFail extends BaseSubAction<History> {
    static readonly type: string = `[{0}] History Fail`;
  }
}

export const dlcmResourceActionNameSpace: DlcmResourceNameSpace | any = DlcmResourceAction;
