import {Injectable} from "@angular/core";
import {AdminResourceApiEnum} from "@app/shared/enums/api.enum";
import {environment} from "@environments/environment";
import {DisseminationPolicy} from "@models";
import {
  Actions,
  State,
  Store,
} from "@ngxs/store";
import {sharedDisseminationPolicyActionNameSpace} from "@shared/stores/dissemination-policy/shared-dissemination-policy.action";
import {
  ApiService,
  defaultResourceStateInitValue,
  NotificationService,
  OrderEnum,
  QueryParameters,
  ResourceState,
  ResourceStateModel,
} from "solidify-frontend";
import {LocalStateEnum} from "../../enums/local-state.enum";

export interface SharedDisseminationPolicyStateModel extends ResourceStateModel<DisseminationPolicy> {
}

@Injectable()
@State<SharedDisseminationPolicyStateModel>({
  name: LocalStateEnum.shared_dissemination_policy,
  defaults: {
    ...defaultResourceStateInitValue(),
    queryParameters: new QueryParameters(environment.defaultEnumValuePageSizeOption, {
      field: "name",
      order: OrderEnum.ascending,
    }),
  },
})
export class SharedDisseminationPolicyState extends ResourceState<SharedDisseminationPolicyStateModel, DisseminationPolicy> {
  constructor(protected apiService: ApiService,
              protected store: Store,
              protected notificationService: NotificationService,
              protected actions$: Actions) {
    super(apiService, store, notificationService, actions$, {
      nameSpace: sharedDisseminationPolicyActionNameSpace,
    });
  }

  protected get _urlResource(): string {
    return AdminResourceApiEnum.disseminationPolicies;
  }
}
