import {Injectable} from "@angular/core";
import {PreIngestResourceApiEnum} from "@app/shared/enums/api.enum";
import {LocalStateEnum} from "@app/shared/enums/local-state.enum";
import {environment} from "@environments/environment";
import {Deposit} from "@models";
import {
  Actions,
  State,
  Store,
} from "@ngxs/store";
import {sharedDepositActionNameSpace} from "@shared/stores/deposit/shared-deposit.action";
import {
  ApiService,
  defaultResourceStateInitValue,
  NotificationService,
  OrderEnum,
  QueryParameters,
  ResourceState,
  ResourceStateModel,
  Sort,
} from "solidify-frontend";

export interface SharedDepositStateModel extends ResourceStateModel<Deposit> {
}

@Injectable()
@State<SharedDepositStateModel>({
  name: LocalStateEnum.shared_deposit,
  defaults: {
    ...defaultResourceStateInitValue(),
    queryParameters: new QueryParameters(environment.defaultEnumValuePageSizeOption, {field: "title", order: OrderEnum.ascending} as Sort),
  },
})
export class SharedDepositState extends ResourceState<SharedDepositStateModel, Deposit> {
  constructor(protected apiService: ApiService,
              protected store: Store,
              protected notificationService: NotificationService,
              protected actions$: Actions) {
    super(apiService, store, notificationService, actions$, {
      nameSpace: sharedDepositActionNameSpace,
    });
  }

  protected get _urlResource(): string {
    return PreIngestResourceApiEnum.deposits;
  }
}
