import {Injectable} from "@angular/core";
import {PreIngestResourceApiEnum} from "@app/shared/enums/api.enum";
import {LocalStateEnum} from "@app/shared/enums/local-state.enum";
import {environment} from "@environments/environment";
import {Contributor} from "@models";
import {
  Actions,
  Selector,
  State,
  Store,
} from "@ngxs/store";
import {sharedContributorActionNameSpace} from "@shared/stores/contributor/shared-contributor.action";
import {
  ApiService,
  defaultResourceStateInitValue,
  NotificationService,
  QueryParameters,
  ResourceState,
  ResourceStateModel,
  StoreUtil,
} from "solidify-frontend";

export interface SharedContributorStateModel extends ResourceStateModel<Contributor> {
}

@Injectable()
@State<SharedContributorStateModel>({
  name: LocalStateEnum.shared_contributor,
  defaults: {
    ...defaultResourceStateInitValue(),
    queryParameters: new QueryParameters(environment.defaultEnumValuePageSizeOption),
  },
})
export class SharedContributorState extends ResourceState<SharedContributorStateModel, Contributor> {
  constructor(protected apiService: ApiService,
              protected store: Store,
              protected notificationService: NotificationService,
              protected actions$: Actions) {
    super(apiService, store, notificationService, actions$, {
      nameSpace: sharedContributorActionNameSpace,
    });
  }

  protected get _urlResource(): string {
    return PreIngestResourceApiEnum.contributors;
  }

  @Selector()
  static isLoading<T>(state: ResourceStateModel<T>): boolean {
    return StoreUtil.isLoadingState(state);
  }
}
