import {Injectable} from "@angular/core";
import {ArchiveACL} from "@models";
import {
  Actions,
  State,
  Store,
} from "@ngxs/store";
import {AdminResourceApiEnum} from "@shared/enums/api.enum";
import {LocalStateEnum} from "@shared/enums/local-state.enum";
import {sharedArchiveAclActionNameSpace} from "@shared/stores/archive-acl/shared-archive-acl.action";
import {
  ApiService,
  defaultResourceStateInitValue,
  MARK_AS_TRANSLATABLE,
  NotificationService,
  ResourceState,
  ResourceStateModel,
} from "solidify-frontend";

export interface SharedArchiveAclStateModel extends ResourceStateModel<ArchiveACL> {
}

@Injectable()
@State<SharedArchiveAclStateModel>({
  name: LocalStateEnum.shared_archiveAcl,
  defaults: {
    ...defaultResourceStateInitValue(),
  },
  children: [],
})
export class SharedArchiveAclState extends ResourceState<SharedArchiveAclStateModel, ArchiveACL> {
  constructor(protected apiService: ApiService,
              protected store: Store,
              protected notificationService: NotificationService,
              protected actions$: Actions) {
    super(apiService, store, notificationService, actions$, {
      nameSpace: sharedArchiveAclActionNameSpace,
      notificationResourceCreateFailTextToTranslate: MARK_AS_TRANSLATABLE("archiveAcl.create.notification.fail"),
      notificationResourceCreateSuccessTextToTranslate: MARK_AS_TRANSLATABLE("archiveAcl.create.notification.success"),
      notificationResourceUpdateFailTextToTranslate: MARK_AS_TRANSLATABLE("archiveAcl.update.notification.fail"),
      notificationResourceUpdateSuccessTextToTranslate: MARK_AS_TRANSLATABLE("archiveAcl.update.notification.success"),
      notificationResourceDeleteFailTextToTranslate: MARK_AS_TRANSLATABLE("archiveAcl.delete.notification.fail"),
      notificationResourceDeleteSuccessTextToTranslate: MARK_AS_TRANSLATABLE("archiveAcl.delete.notification.success"),
    });
  }

  protected get _urlResource(): string {
    return AdminResourceApiEnum.archiveAcl;
  }
}
