import {DragDropModule} from "@angular/cdk/drag-drop";
import {LayoutModule} from "@angular/cdk/layout";
import {TextFieldModule} from "@angular/cdk/text-field";
import {CommonModule} from "@angular/common";
import {NgModule} from "@angular/core";
import {
  FormsModule,
  ReactiveFormsModule,
} from "@angular/forms";
import {
  MAT_DIALOG_DEFAULT_OPTIONS,
  MatDialogConfig,
} from "@angular/material/dialog";
import {MatSpinner} from "@angular/material/progress-spinner";
import {MaterialModule} from "@app/material.module";
import {SharedDataTablePresentational} from "@app/shared/components/presentationals/shared-data-table/shared-data-table.presentational";
import {SharedErrorPresentational} from "@app/shared/components/presentationals/shared-error/shared-error.presentational";
import {SharedFieldErrorPresentational} from "@app/shared/components/presentationals/shared-field-error/shared-field-error.presentational";
import {SharedMultiSelectPresentational} from "@app/shared/components/presentationals/shared-multi-select/shared-multi-select.presentational";
import {SharedSearchPresentational} from "@app/shared/components/presentationals/shared-search/shared-search.presentational";
import {FileSizePipe} from "@app/shared/pipes/file-size.pipe";
import {SharedInstitutionState} from "@app/shared/stores/institution/shared-institution.state";
import {SharedLanguageState} from "@app/shared/stores/language/shared-language.state";
import {SharedLicenseState} from "@app/shared/stores/license/shared-license.state";
import {SharedOrganizationalUnitState} from "@app/shared/stores/organizational-unit/shared-organizational-unit.state";
import {SharedPersonState} from "@app/shared/stores/person/shared-person.state";
import {SharedPreservationPolicyState} from "@app/shared/stores/preservation-policy/shared-preservation-policy.state";
import {SharedState} from "@app/shared/stores/shared.state";
import {SharedSubmissionPolicyState} from "@app/shared/stores/submission-policy/shared-submission-policy.state";
import {
  FaIconLibrary,
  FontAwesomeModule,
} from "@fortawesome/angular-fontawesome";
import {fas} from "@fortawesome/free-solid-svg-icons";
import {ArchiveAccessRightService} from "@home/services/archive-access-right.service";
import {FormlyModule} from "@ngx-formly/core";
import {TranslateModule} from "@ngx-translate/core";
import {NgxsModule} from "@ngxs/store";
import {SharedArchiveNameContainer} from "@shared/components/containers/shared-archive-name/shared-archive-name.container";
import {SharedAvatarUploadWrapperContainer} from "@shared/components/containers/shared-avatar-upload-wrapper/shared-avatar-upload-wrapper.container";
import {SharedFileAndAipInformationContainer} from "@shared/components/containers/shared-file-and-aip-information/shared-file-and-aip-information.container";
import {SharedImageUploadWrapperContainer} from "@shared/components/containers/shared-image-upload-wrapper/shared-image-upload-wrapper.container";
import {SharedLogoWrapperContainer} from "@shared/components/containers/shared-logo-wrapper/shared-logo-wrapper.container";
import {SharedOrganizationalUnitMemberContainer} from "@shared/components/containers/shared-organizational-unit-member/shared-organizational-unit-member.container";
import {SharedOrganizationalUnitNameContainer} from "@shared/components/containers/shared-organizational-unit-name/shared-organizational-unit-name.container";
import {SharedTablePersonOrgunitRoleContainer} from "@shared/components/containers/shared-table-person-orgunit-role/shared-table-person-orgunit-role.container";
import {SharedTabsContainer} from "@shared/components/containers/shared-tabs/shared-tabs.container";
import {SharedUserguideSidebarContainer} from "@shared/components/containers/shared-userguide-sidebar/shared-userguide-sidebar.container";
import {SharedDeleteDialog} from "@shared/components/dialogs/shared-abstract-delete/shared-delete.dialog";
import {SharedBaseActionDialog} from "@shared/components/dialogs/shared-base-action/shared-base-action.dialog";
import {SharedBaseInfoDialog} from "@shared/components/dialogs/shared-base-info/shared-base-info.dialog";
import {SharedConfirmDialog} from "@shared/components/dialogs/shared-confirm/shared-confirm.dialog";
import {SharedDataTableLooseSelectionDialog} from "@shared/components/dialogs/shared-data-table-loose-selection/shared-data-table-loose-selection.dialog";
import {SharedHistoryDialog} from "@shared/components/dialogs/shared-history/shared-history.dialog";
import {SharedInfoExcludedIgnoredFileDialog} from "@shared/components/dialogs/shared-info-excluded-ignored-file/shared-info-excluded-ignored-file.dialog";
import {SharedPreviewDialog} from "@shared/components/dialogs/shared-preview/shared-preview.dialog";
import {SharedUploadImageDialog} from "@shared/components/dialogs/shared-upload-image/shared-upload-image.dialog";
import {SharedAccessLevelPresentational} from "@shared/components/presentationals/shared-access-level/shared-access-level.presentational";
import {SharedAdditionalInformationPanelContainer} from "@shared/components/presentationals/shared-additional-information-panel/shared-additional-information-panel.container";
import {SharedAdminResearchDomainLabelPresentational} from "@shared/components/presentationals/shared-admin-research-domain-label/shared-admin-research-domain-label.presentational";
import {SharedAipStatusNamePresentational} from "@shared/components/presentationals/shared-aip-status-name/shared-aip-status-name.presentational";
import {SharedAipStatusOrgunitNamePresentational} from "@shared/components/presentationals/shared-aip-status-orgunit-name/shared-aip-status-orgunit-name.presentational";
import {SharedAipStatusSummaryPresentational} from "@shared/components/presentationals/shared-aip-status-summary/shared-aip-status-summary.presentational";
import {SharedArchivePublicationDatePresentational} from "@shared/components/presentationals/shared-archive-publication-date/shared-archive-publication-date.presentational";
import {SharedArchiveRatingStarPresentational} from "@shared/components/presentationals/shared-archive-rating-star/shared-archive-rating-star.presentational";
import {SharedArchiveTilePresentational} from "@shared/components/presentationals/shared-archive-tile/shared-archive-tile.presentational";
import {SharedAvatarPresentational} from "@shared/components/presentationals/shared-avatar/shared-avatar.presentational";
import {SharedBannerPresentational} from "@shared/components/presentationals/shared-banner/shared-banner.presentational";
import {SharedButtonIdPresentational} from "@shared/components/presentationals/shared-button-id/shared-button-id.presentational";
import {SharedButtonRefreshPresentational} from "@shared/components/presentationals/shared-button-refresh/shared-button-refresh.presentational";
import {SharedButtonStatusHistoryPresentational} from "@shared/components/presentationals/shared-button-status-history/shared-button-status-history.presentational";
import {SharedButtonToolbarDetailPresentational} from "@shared/components/presentationals/shared-button-toolbar-detail/shared-button-toolbar-detail.presentational";
import {SharedButtonToolbarListPresentational} from "@shared/components/presentationals/shared-button-toolbar-list/shared-button-toolbar-list.presentational";
import {SharedChecksumPresentational} from "@shared/components/presentationals/shared-checksum/shared-checksum.presentational";
import {SharedComplianceLevelPresentational} from "@shared/components/presentationals/shared-compliance-level/shared-compliance-level.presentational";
import {SharedDataSensitivityPresentational} from "@shared/components/presentationals/shared-data-sensitivity/shared-data-sensitivity.presentational";
import {SharedDatafileQuickStatusPresentational} from "@shared/components/presentationals/shared-datafile-quick-status/shared-datafile-quick-status.presentational";
import {SharedDetailPresentationPresentational} from "@shared/components/presentationals/shared-detail-presentation/shared-detail-presentation.presentational";
import {SharedDoiMenuPresentational} from "@shared/components/presentationals/shared-doi-menu/shared-doi-menu.presentational";
import {SharedFolderTreePresentational} from "@shared/components/presentationals/shared-folder-tree/shared-folder-tree.presentational";
import {SharedIconPresentational} from "@shared/components/presentationals/shared-icon/shared-icon.presentational";
import {SharedImageDisplayPresentational} from "@shared/components/presentationals/shared-image-display/shared-image-display.presentational";
import {SharedKeywordInputPresentational} from "@shared/components/presentationals/shared-keyword-input/shared-keyword-input.presentational";
import {SharedMultiSelectContentPresentational} from "@shared/components/presentationals/shared-multi-select-content/shared-multi-select-content.presentational";
import {SharedMultiSelectDefaultValueContentPresentational} from "@shared/components/presentationals/shared-multi-select-default-value-content/shared-multi-select-default-value-content.presentational";
import {SharedNotificationFormPresentational} from "@shared/components/presentationals/shared-notification-form/shared-notification-form.presentational";
import {SharedPanelExpandablePresentational} from "@shared/components/presentationals/shared-panel-expandable/shared-panel-expandable.presentational";
import {SharedPersonFormPresentational} from "@shared/components/presentationals/shared-person-form/shared-person-form.presentational";
import {SharedPreservationDurationPresentational} from "@shared/components/presentationals/shared-preservation-duration/shared-preservation-duration.presentational";
import {SharedSearchableMultiSelectContentPresentational} from "@shared/components/presentationals/shared-searchable-multi-select-content/shared-searchable-multi-select-content.presentational";
import {SharedSearchableMultiSelectPresentational} from "@shared/components/presentationals/shared-searchable-multi-select/shared-searchable-multi-select.presentational";
import {SharedSearchableSingleSelectContentPresentational} from "@shared/components/presentationals/shared-searchable-single-select-content/shared-searchable-single-select-content.presentational";
import {SharedSearchableSingleSelectPresentational} from "@shared/components/presentationals/shared-searchable-single-select/shared-searchable-single-select.presentational";
import {SharedSnackbarPresentational} from "@shared/components/presentationals/shared-snackbar/shared-snackbar.presentational";
import {SharedStarRatingPresentational} from "@shared/components/presentationals/shared-star-rating/shared-star-rating.presentational";
import {SharedStatusPresentational} from "@shared/components/presentationals/shared-status/shared-status.presentational";
import {SharedTocPresentational} from "@shared/components/presentationals/shared-toc/shared-toc.presentational";
import {SharedUrlInputNavigationPresentational} from "@shared/components/presentationals/shared-url-input-navigation/shared-url-input-navigation.presentational";
import {SharedAlternativeButtonDirective} from "@shared/directives/shared-alternative-button/shared-alternative-button.directive";
import {SharedButtonSpinnerDirective} from "@shared/directives/shared-button-spinner/shared-button-spinner.directive";
import {SharedDataTestDirective} from "@shared/directives/shared-data-test/shared-data-test.directive";
import {SharedMatButtonThemeDirective} from "@shared/directives/shared-mat-button-theme/shared-mat-button-theme.directive";
import {SharedRoundButtonDirective} from "@shared/directives/shared-round-button/shared-round-button.directive";
import {SharedSpinnerDirective} from "@shared/directives/shared-spinner/shared-spinner.directive";
import {SharedTooltipOnEllipsisDirective} from "@shared/directives/shared-tooltip-on-ellipsis/shared-tooltip-on-ellipsis.directive";
import {SharedAipCollectionState} from "@shared/features/aip/stores/aip-collection/shared-aip-collection.state";
import {SharedAipCollectionStatusHistoryState} from "@shared/features/aip/stores/aip-collection/status-history/shared-aip-collection-status-history.state";
import {SharedAipDataFileState} from "@shared/features/aip/stores/aip-data-file/shared-aip-data-file.state";
import {SharedAipDataFileStatusHistoryState} from "@shared/features/aip/stores/aip-data-file/status-history/shared-aip-data-file-status-history.state";
import {SharedAipOrganizationalUnitState} from "@shared/features/aip/stores/organizational-unit/shared-aip-organizational-unit.state";
import {SharedAipState} from "@shared/features/aip/stores/shared-aip.state";
import {SharedAipStatusHistoryState} from "@shared/features/aip/stores/status-history/shared-aip-status-history.state";
import {FileVisualizerPresentational} from "@shared/filevisualizer/components/file-visualizer.component";
import {AddExternalComponentDirective} from "@shared/filevisualizer/directives/add-external-component.directive";
import {PdfViewerWithToolBarPresentational} from "@shared/filevisualizer/plugin/pdfviewerwithtoolbar/pdf-viewer-with-tool-bar.component";
import {FILE_VISUALIZERS} from "@shared/filevisualizer/services/abstract-file-visualizer.service";
import {ImageFileVisualizerService} from "@shared/filevisualizer/services/image-file-visualizer.service";
import {MolFileVisualizerService} from "@shared/filevisualizer/services/mol-file-visualizer.service";
import {PdfFileVisualizerWithToolBarService} from "@shared/filevisualizer/services/pdf-file-visualizer-with-tool-bar.service";
import {SmeFileVisualizerService} from "@shared/filevisualizer/services/sme-file-visualizer.service";
import {SoundFileVisualizerService} from "@shared/filevisualizer/services/sound-file-visualizer.service";
import {TextFileVisualizerService} from "@shared/filevisualizer/services/text-file-visualizer.service";
import {VideoClassicalFileVisualizerService} from "@shared/filevisualizer/services/video-classical-file-visualizer.service";
import {ClonePipe} from "@shared/pipes/clone.pipe";
import {DatetimePipe} from "@shared/pipes/datetime.pipe";
import {SolidifyAsyncPipe} from "@shared/pipes/solidify-async.pipe";
import {TranslateFacetPipe} from "@shared/pipes/translate-facet.pipe";
import {AppStatusService} from "@shared/services/app-status.service";
import {AppTourService} from "@shared/services/app-tour.service";
import {BreakpointService} from "@shared/services/breakpoint.service";
import {CanDeactivateGuard} from "@shared/services/can-deactivate-guard.service";
import {GoogleAnalyticsService} from "@shared/services/google-analytics.service";
import {OrcidService} from "@shared/services/orcid.service";
import {RouterExtService} from "@shared/services/router-ext.service";
import {SecurityService} from "@shared/services/security.service";
import {SharedArchiveAclState} from "@shared/stores/archive-acl/shared-archive-acl.state";
import {SharedArchiveState} from "@shared/stores/archive/shared-archive.state";
import {SharedContributorState} from "@shared/stores/contributor/shared-contributor.state";
import {SharedDepositState} from "@shared/stores/deposit/shared-deposit.state";
import {SharedDisseminationPolicyState} from "@shared/stores/dissemination-policy/shared-dissemination-policy.state";
import {SharedFundingAgencyState} from "@shared/stores/funding-agency/shared-funding-agency.state";
import {SharedIndexFieldAliasState} from "@shared/stores/index-field-alias/shared-index-field-alias.state";
import {SharedMetadataTypeState} from "@shared/stores/metadata-type/shared-metadata-type.state";
import {SharedNotificationState} from "@shared/stores/notification/shared-notification.state";
import {SharedOaiSetState} from "@shared/stores/oai-set/shared-oai-set.state";
import {SharedOauth2ClientState} from "@shared/stores/oauth-2-client/shared-oauth-2-client.state";
import {SharedOrderState} from "@shared/stores/order/shared-order.state";
import {SharedOrganizationalUnitDisseminationPolicyState} from "@shared/stores/organizational-unit/dissemination-policy/shared-organizational.unit-dissemination-policy.state";
import {SharedOrganizationalUnitPreservationPolicyState} from "@shared/stores/organizational-unit/preservation-policy/shared-organizational-unit-preservation-policy.state";
import {SharedOrganizationalUnitSubmissionPolicyState} from "@shared/stores/organizational-unit/submission-policy/shared-organizational-unit-submission-policy.state";
import {SharedResearchDomainState} from "@shared/stores/research-domain/shared-research-domain.state";
import {SharedRoleState} from "@shared/stores/role/shared-role.state";
import {SharedUserState} from "@shared/stores/user/shared-user.state";
import {SharedVisualizationState} from "@shared/stores/visualization/shared-visualization-state.service";
import {
  PdfViewerComponent,
  PdfViewerModule,
} from "ng2-pdf-viewer";
import {
  NgxDocViewerComponent,
  NgxDocViewerModule,
} from "ngx-doc-viewer";
import {HighlightModule} from "ngx-highlightjs";
import {ImageCropperModule} from "ngx-image-cropper";
import {TourMatMenuModule} from "ngx-tour-md-menu";
import {SolidifyFrontendModule} from "solidify-frontend";
import {SharedBreadcrumbPresentational} from "./components/presentationals/shared-breadcrumb/shared-breadcrumb.presentational";
import {SharedPaginatorPresentational} from "./components/presentationals/shared-paginator/shared-paginator.presentational";

const routables = [
  SharedFileAndAipInformationContainer,
];
const containers = [
  SharedOrganizationalUnitNameContainer,
  SharedOrganizationalUnitMemberContainer,
  SharedArchiveNameContainer,
  SharedTabsContainer,
  SharedUserguideSidebarContainer,
  SharedAvatarUploadWrapperContainer,
  SharedImageUploadWrapperContainer,
  SharedTablePersonOrgunitRoleContainer,
  SharedAdditionalInformationPanelContainer,
  SharedLogoWrapperContainer,
];
const dialogs = [
  SharedBaseActionDialog,
  SharedBaseInfoDialog,
  SharedHistoryDialog,
  SharedDataTableLooseSelectionDialog,
  SharedConfirmDialog,
  SharedPreviewDialog,
  SharedInfoExcludedIgnoredFileDialog,
  SharedUploadImageDialog,
  SharedDeleteDialog,
];
const contents = [
  SharedSearchableSingleSelectContentPresentational,
  SharedSearchableMultiSelectContentPresentational,
  SharedMultiSelectContentPresentational,
  SharedMultiSelectDefaultValueContentPresentational,
];
const presentationals = [
  SharedDetailPresentationPresentational,
  SharedArchiveRatingStarPresentational,
  SharedAvatarPresentational,
  SharedNotificationFormPresentational,
  SharedIconPresentational,
  FileVisualizerPresentational,
  SharedTocPresentational,
  SharedButtonToolbarDetailPresentational,
  SharedComplianceLevelPresentational,
  SharedSearchPresentational,
  SharedDataTablePresentational,
  SharedPaginatorPresentational,
  SharedBreadcrumbPresentational,
  SharedMultiSelectPresentational,
  SharedFieldErrorPresentational,
  PdfViewerWithToolBarPresentational,
  SharedErrorPresentational,
  SharedSearchableSingleSelectPresentational,
  SharedSearchableMultiSelectPresentational,
  SharedButtonStatusHistoryPresentational,
  SharedPersonFormPresentational,
  SharedSnackbarPresentational,
  SharedAipStatusSummaryPresentational,
  SharedAipStatusNamePresentational,
  SharedAipStatusOrgunitNamePresentational,
  SharedStarRatingPresentational,
  SharedDoiMenuPresentational,
  SharedButtonIdPresentational,
  SharedBannerPresentational,
  SharedPanelExpandablePresentational,
  SharedChecksumPresentational,
  SharedDatafileQuickStatusPresentational,
  SharedAdminResearchDomainLabelPresentational,
  SharedKeywordInputPresentational,
  SharedUrlInputNavigationPresentational,
  SharedButtonRefreshPresentational,
  SharedButtonToolbarListPresentational,
  SharedPreservationDurationPresentational,
  SharedAccessLevelPresentational,
  SharedArchivePublicationDatePresentational,
  SharedDataSensitivityPresentational,
  SharedStatusPresentational,
  SharedArchiveTilePresentational,
  SharedImageDisplayPresentational,
  SharedFolderTreePresentational,
];
const directives = [
  SharedSpinnerDirective,
  SharedButtonSpinnerDirective,
  SharedAlternativeButtonDirective,
  SharedRoundButtonDirective,
  SharedMatButtonThemeDirective,
  SharedDataTestDirective,
  AddExternalComponentDirective,
  SharedTooltipOnEllipsisDirective,
];
const pipes = [
  FileSizePipe,
  DatetimePipe,
  ClonePipe,
  SolidifyAsyncPipe,
  TranslateFacetPipe,
];
const services = [
  CanDeactivateGuard,
  BreakpointService,
  AppStatusService,
  SecurityService,
  AppTourService,
  OrcidService,
  RouterExtService,
  ArchiveAccessRightService,
  GoogleAnalyticsService,
];
const modules = [
  CommonModule,
  NgxDocViewerModule,
  PdfViewerModule,
  FormsModule,
  ReactiveFormsModule,
  FormlyModule,
  MaterialModule,
  FontAwesomeModule,
  TranslateModule,
  SolidifyFrontendModule,
  TextFieldModule,
  LayoutModule,
  DragDropModule,
  HighlightModule,
  ImageCropperModule,
  TourMatMenuModule,
];

@NgModule({
  declarations: [
    ...routables,
    ...containers,
    ...dialogs,
    ...contents,
    ...presentationals,
    ...directives,
    ...pipes,
  ],
  imports: [
    ...modules,
    NgxsModule.forFeature([
      SharedState,
      SharedArchiveAclState,
      SharedLicenseState,
      SharedDepositState,
      SharedLanguageState,
      SharedPreservationPolicyState,
      SharedSubmissionPolicyState,
      SharedOrganizationalUnitState,
      SharedDisseminationPolicyState,
      SharedPersonState,
      SharedInstitutionState,
      SharedRoleState,
      SharedOrganizationalUnitSubmissionPolicyState,
      SharedOrganizationalUnitPreservationPolicyState,
      SharedOrganizationalUnitDisseminationPolicyState,
      SharedFundingAgencyState,
      SharedResearchDomainState,
      SharedNotificationState,
      SharedOauth2ClientState,
      SharedUserState,
      SharedContributorState,
      SharedOrderState,
      SharedOaiSetState,
      SharedMetadataTypeState,
      SharedVisualizationState,
      SharedAipState,
      SharedAipOrganizationalUnitState,
      SharedAipCollectionState,
      SharedAipStatusHistoryState,
      SharedAipCollectionStatusHistoryState,
      SharedAipDataFileState,
      SharedAipDataFileStatusHistoryState,
      SharedArchiveState,
      SharedIndexFieldAliasState,
    ]),
  ],
  exports: [
    ...modules,
    ...routables,
    ...containers,
    ...dialogs,
    ...presentationals,
    ...contents,
    ...directives,
    ...pipes,
  ],
  providers: [
    ...services,
    {provide: FILE_VISUALIZERS, useClass: ImageFileVisualizerService, multi: true},
    {provide: FILE_VISUALIZERS, useClass: SmeFileVisualizerService, multi: true},
    {provide: FILE_VISUALIZERS, useClass: VideoClassicalFileVisualizerService, multi: true},
    {provide: FILE_VISUALIZERS, useClass: PdfFileVisualizerWithToolBarService, multi: true},
    {provide: FILE_VISUALIZERS, useClass: SoundFileVisualizerService, multi: true},
    {provide: FILE_VISUALIZERS, useClass: MolFileVisualizerService, multi: true},
    {provide: FILE_VISUALIZERS, useClass: TextFileVisualizerService, multi: true},
    {provide: MAT_DIALOG_DEFAULT_OPTIONS, useValue: {panelClass: "dlcm-dialogs", hasBackdrop: true} as MatDialogConfig},
    // TODO reactive this class when find a solution for public url to visualize all type of document
    //{provide: FILE_VISUALIZERS, useClass: Ng2XsViewerVisualizerService, multi: true},
    // TODO use Video VideoFileVisualizerService when all video will be supported and when add a converter
    //{provide: FILE_VISUALIZERS, useClass: VideoFileVisualizerService, multi: true},
    // Visualization of PDF with no toolbar
    //{provide: FILE_VISUALIZERS, useClass: PdfFileVisualizerService, multi: true},
  ],
  entryComponents: [
    ...dialogs,
    SharedSnackbarPresentational,
    SharedErrorPresentational,
    PdfViewerWithToolBarPresentational,
    NgxDocViewerComponent,
    PdfViewerComponent,
    ...contents,
    MatSpinner,
  ],
})
export class SharedModule {
  constructor(private library: FaIconLibrary) {
    // Fontawesome library
    library.addIconPacks(fas);
  }
}
