import {
  ElementRef,
  Injectable,
} from "@angular/core";
import {
  Actions,
  Store,
} from "@ngxs/store";
import {
  BehaviorSubject,
  Observable,
} from "rxjs";
import {
  isNullOrUndefined,
  ObservableUtil,
} from "solidify-frontend";

@Injectable({
  providedIn: "root",
})
export class ScrollService {
  private mainElementRef: ElementRef;

  private readonly _scrollEventMainBS: BehaviorSubject<any>;
  readonly scrollEventMainObs: Observable<Event | undefined>;

  constructor(private readonly _store: Store,
              private readonly _actions$: Actions) {
    this._scrollEventMainBS = new BehaviorSubject<Event>(undefined);
    this.scrollEventMainObs = ObservableUtil.asObservable(this._scrollEventMainBS);
  }

  triggerScrollEventMain($event: Event): void {
    this._scrollEventMainBS.next($event);
  }

  init(mainElementRef: ElementRef): void {
    if (isNullOrUndefined(mainElementRef)) {
      return;
    }
    this.mainElementRef = mainElementRef;
  }

  scrollToTop(withTimeout: boolean = false): void {
    if (!this._checkIsInit()) {
      return;
    }
    if (withTimeout) {
      setTimeout(() => {
        this._scrollToTop();
      }, 0);
    } else {
      this._scrollToTop();
    }
  }

  private _scrollToTop(): void {
    this.mainElementRef?.nativeElement?.scroll(0, 0);
  }

  private _checkIsInit(): boolean {
    if (isNullOrUndefined(this.mainElementRef)) {
      console.warn("Scroll service is not initialized");
      return false;
    }

    return true;
  }
}
