import {Injectable} from "@angular/core";
import {AppSystemPropertyState} from "@app/stores/system-property/app-system-property.state";
import {environment} from "@environments/environment";
import {Store} from "@ngxs/store";
import {AdminResourceApiEnum} from "@shared/enums/api.enum";
import {
  ApiService,
  MemoizedUtil,
} from "solidify-frontend";

@Injectable({
  providedIn: "root",
})
export class OrcidService {
  constructor(private readonly _apiService: ApiService,
              private readonly _store: Store) {
  }

  public startOrcidAuth(): void {
    const startOrcidAuthUrl = AdminResourceApiEnum.orcid + "/start-orcid-auth";
    const originUrl: string = window.location.href;
    let orcidQueryParam = environment.orcidQueryParam + "=true";
    if (originUrl.includes("?")) {
      orcidQueryParam = "&" + orcidQueryParam;
    } else {
      orcidQueryParam = "?" + orcidQueryParam;
    }

    this._apiService.get<string>(startOrcidAuthUrl, {}, {"originUrl": originUrl + orcidQueryParam})
      .subscribe(val => this.getOrcid(val["authTransactionId"]));
  }

  private getOrcid(authTransactionId: string): void {
    const authorizeUrl: string = environment.orcidAuthorizeUrl;
    const clientId: string = MemoizedUtil.selectSnapshot(this._store, AppSystemPropertyState, state => state.current.orcidClientId);
    const redirectUri: string = AdminResourceApiEnum.orcid + "/landing?authTransactionId=" + authTransactionId;
    window.location.href = authorizeUrl
      + "?client_id=" + clientId
      + "&response_type=code"
      + "&scope=/authenticate"
      + "&redirect_uri=" + redirectUri;
  }
}
