import {
  ComponentType,
  Overlay,
  OverlayContainer,
} from "@angular/cdk/overlay";
import {Location} from "@angular/common";
import {
  ElementRef,
  Inject,
  Injectable,
  Injector,
  NgZone,
  OnDestroy,
  Optional,
  SkipSelf,
  TemplateRef,
} from "@angular/core";
import {
  MAT_DIALOG_DEFAULT_OPTIONS,
  MAT_DIALOG_SCROLL_STRATEGY,
  MatDialog,
  MatDialogConfig,
  MatDialogRef,
} from "@angular/material/dialog";
import {TabulationService} from "@shared/services/tabulation.service";
import {SubscriptionManager} from "solidify-frontend";

@Injectable()
export class MatDialogOverrideService extends MatDialog implements OnDestroy {

  private readonly _subscriptionManager: SubscriptionManager = new SubscriptionManager();
  lasActiveElement: Element;

  constructor(_overlay: Overlay,
              _injector: Injector,
              @Optional() _location: Location,
              private _ngZone: NgZone,
              @Optional() @Inject(MAT_DIALOG_DEFAULT_OPTIONS) _defaultOptions: MatDialogConfig,
              @Inject(MAT_DIALOG_SCROLL_STRATEGY) scrollStrategy: any,
              @Optional() @SkipSelf() _parentDialog: MatDialog,
              _overlayContainer: OverlayContainer,
              @Optional() private readonly _elementRef: ElementRef,
              private readonly _tabulationService: TabulationService) {
    super(_overlay,
      _injector,
      _location,
      _defaultOptions,
      scrollStrategy,
      _parentDialog,
      _overlayContainer);
    this._ngZone.runOutsideAngular(() => document.addEventListener("focusin", focusEvent => this.lasActiveElement = document.activeElement));
  }

  ngOnDestroy(): void {
    super.ngOnDestroy();
    this._subscriptionManager.clearAndUnsubscribeAll();
  }

  open<T, D = any, R = any>(componentOrTemplateRef: ComponentType<T> | TemplateRef<T>, config?: MatDialogConfig<D>): MatDialogRef<T, R> {
    const lastActiveElement: Element = this.lasActiveElement;
    const matDialogRef = super.open(componentOrTemplateRef, config);
    this._subscriptionManager.subscribe(
      matDialogRef.afterClosed(),
      () => {
        this._tabulationService.focusPrev(lastActiveElement);
      },
    );
    return matDialogRef;
  }
}
