import {Injectable} from "@angular/core";
import {isNullOrUndefined} from "solidify-frontend";

@Injectable({
  providedIn: "root",
})
export class ErrorsSkipperService {
  private _errorHttpCodeToSkipTemporary: number[];

  constructor() {
    this.init();
  }

  init(): void {
    if (isNullOrUndefined(this._errorHttpCodeToSkipTemporary)) {
      this._errorHttpCodeToSkipTemporary = [];
    }
  }

  addErrorSoSkip(error: number): void {
    if (!this._errorHttpCodeToSkipTemporary.includes(error)) {
      this._errorHttpCodeToSkipTemporary.push(error);
    }
  }

  removeErrorSoSkip(error: number): void {
    if (!this._errorHttpCodeToSkipTemporary.includes(error)) {
      return;
    }
    const index = this._errorHttpCodeToSkipTemporary.indexOf(error);
    if (index === -1) {
      return;
    }
    this._errorHttpCodeToSkipTemporary.splice(index, 1);
  }

  shouldBeSkipped(error: number): boolean {
    if (this._errorHttpCodeToSkipTemporary.includes(error)) {
      this.removeErrorSoSkip(error);
      return true;
    }
    return false;
  }
}
