import {
  Injectable,
  OnDestroy,
} from "@angular/core";
import {MatPaginatorIntl} from "@angular/material/paginator";
import {TranslateService} from "@ngx-translate/core";
import {
  Subject,
  Subscription,
} from "rxjs";
import {takeUntil} from "rxjs/operators";

@Injectable({
  providedIn: "root",
})
export class CustomMatPaginatorIntlService extends MatPaginatorIntl implements OnDestroy {

  subscription: Subscription;
  unsubscribeSubject: Subject<void> = new Subject<void>();
  ofLabel: string;

  constructor(private translate: TranslateService) {
    super();

    this.translate.onLangChange.pipe(takeUntil(this.unsubscribeSubject)).subscribe(() => {
      this.getAndInitTranslations();
    });

    this.getAndInitTranslations();
  }

  ngOnDestroy(): void {
    this.unsubscribeSubject.next();
    this.unsubscribeSubject.complete();

    if (this.subscription) {
      this.subscription.unsubscribe();
      this.subscription = null;
    }
  }

  getAndInitTranslations(): void {
    this.subscription = this.translate.get([
      "table.paginator.itemPerPage",
      "table.paginator.nextPage",
      "table.paginator.previousPage",
      "table.paginator.lastPage",
      "table.paginator.firstPage",
      "table.paginator.ofLabel",
    ]).pipe(takeUntil(this.unsubscribeSubject))
      .subscribe(translation => {
        this.itemsPerPageLabel = translation["table.paginator.itemPerPage"];
        this.nextPageLabel = translation["table.paginator.nextPage"];
        this.previousPageLabel = translation["table.paginator.previousPage"];
        this.previousPageLabel = translation["table.paginator.lastPage"];
        this.previousPageLabel = translation["table.paginator.firstPage"];
        this.ofLabel = translation["table.paginator.ofLabel"];
        this.changes.next();
      });
  }

  getRangeLabel = (page: number, pageSize: number, length: number) => {
    if (length === 0 || pageSize === 0) {
      return `0 ${this.ofLabel} ${length}`;
    }
    length = Math.max(length, 0);
    const startIndex = page * pageSize;
    const endIndex = startIndex < length ? Math.min(startIndex + pageSize, length) : startIndex + pageSize;
    return `${startIndex + 1} - ${endIndex} ${this.ofLabel} ${length}`;
  }
}
