import {
  Injectable,
  Injector,
} from "@angular/core";
import {
  ActivatedRouteSnapshot,
  CanDeactivate,
  RouterStateSnapshot,
} from "@angular/router";
import {AppAction} from "@app/stores/app.action";
import {TranslateService} from "@ngx-translate/core";
import {Store} from "@ngxs/store";
import {ICanDeactivate} from "@shared/models/can-deactivate.model";
import {LocalStateModel} from "@shared/models/local-state.model";
import {isNullOrUndefined} from "solidify-frontend";

@Injectable()
export class CanDeactivateGuard implements CanDeactivate<ICanDeactivate> {
  constructor(private store: Store,
              private translate: TranslateService,
              private injector: Injector) {
  }

  canDeactivate(component: ICanDeactivate,
                currentRoute: ActivatedRouteSnapshot,
                currentState: RouterStateSnapshot,
                nextState: RouterStateSnapshot,
  ): boolean {
    const globalUnsavedChange = this.store.selectSnapshot((state: LocalStateModel) => state.application.preventExit);
    const ignorePreventLeavePopup = this.store.selectSnapshot((state: LocalStateModel) => state.application.ignorePreventLeavePopup);
    if (!ignorePreventLeavePopup && (globalUnsavedChange || (!isNullOrUndefined(component) && !component.canDeactivate()))) {
      if (confirm(this.getMessage(globalUnsavedChange))) {
        this.store.dispatch(new AppAction.CancelPreventExit());
        return true;
      } else {
        return false;
      }
    }
    return true;
  }

  private getMessage(globalUnsavedChange: boolean): string {
    let message = this.translate.instant("notification.unsavedChanges");
    if (globalUnsavedChange) {
      const globalMessage = this.store.selectSnapshot((state: LocalStateModel) => state.application.preventExitReasonToTranslate);
      if (!isNullOrUndefined(globalMessage)) {
        message = this.translate.instant(globalMessage);
      }
    }
    return message;
  }
}
