import {BreakpointObserver} from "@angular/cdk/layout";
import {Injectable} from "@angular/core";
import {Observable} from "rxjs";
import {map} from "rxjs/operators";
import {environment} from "../../../environments/environment";

@Injectable({
  providedIn: "root",
})
export class BreakpointService {
  readonly regex: RegExp = new RegExp("[A-Za-z]", "i");

  constructor(private breakpointObserver: BreakpointObserver) {
  }

  isSmallerOrEqualThanMdObs(): Observable<boolean> {
    return this.breakpointObserver.observe(`(max-width: ${this.decrement(environment.breakpointMd)})`).pipe(
      map(res => res.matches),
    );
  }

  isBiggerThanMdObs(): Observable<boolean> {
    return this.breakpointObserver.observe(`(max-width: ${this.decrement(environment.breakpointMd)})`).pipe(
      map(res => !res.matches),
    );
  }

  isSmallerOrEqualThanSmObs(): Observable<boolean> {
    return this.breakpointObserver.observe(`(max-width: ${this.decrement(environment.breakpointSm)})`).pipe(
      map(res => res.matches),
    );
  }

  isBiggerThanSmObs(): Observable<boolean> {
    return this.breakpointObserver.observe(`(max-width: ${this.decrement(environment.breakpointSm)})`).pipe(
      map(res => !res.matches),
    );
  }

  isSmallerThanMd(): boolean {
    return this.breakpointObserver.isMatched(`(max-width: ${this.decrement(environment.breakpointMd)})`);
  }

  isSmallerThanSm(): boolean {
    return this.breakpointObserver.isMatched(`(max-width: ${this.decrement(environment.breakpointSm)})`);
  }

  /***
   * Decrement max-width variable to avoid overlap with inclusive interval
   * @param size
   */
  private decrement(size: string): string {
    let numberInString: string = size;
    let suffix: string = "";
    const index = size.search(this.regex);
    if (index !== -1) {
      numberInString = size.substring(0, index);
      suffix = size.substring(index);
    }
    const numberDecremented: number = +numberInString - 1;
    return numberDecremented + suffix;
  }
}
