import {OnInit, Pipe, PipeTransform} from "@angular/core";
import {SharedAbstractPipe} from "@shared/pipes/shared-abstract/shared-abstract.pipe";
import {Observable} from "rxjs";
import {Enums} from "@enums";
import {isNullOrUndefined, MemoizedUtil} from "solidify-frontend";
import {AppState} from "@app/stores/app.state";
import {Store} from "@ngxs/store";
import {FacetProperty, SystemProperty, Label} from "@models";
import {AppSystemPropertyState} from "@app/stores/system-property/app-system-property.state";
import {tap} from "rxjs/operators";

@Pipe({
  name: "translateFacet",
  pure: false
})
export class TranslateFacetPipe extends SharedAbstractPipe implements PipeTransform  {
  appLanguageObs: Observable<Enums.Language.LanguageEnum> = MemoizedUtil.select(this._store, AppState, state => state.appLanguage);
  systemPropertyObs: Observable<SystemProperty> = MemoizedUtil.select(this._store, AppSystemPropertyState, state => state.current);

  currentLanguage: Enums.Language.LanguageEnum;
  searchFacetProperties: FacetProperty[];

  lastReturnedValue: string;
  lastReturnLanguage: Enums.Language.LanguageEnum;

  constructor(private _store: Store) {
    super();
    this.subscribe(this.appLanguageObs.pipe(tap(value => {
      this.currentLanguage = value;
      this.lastReturnLanguage = null;
    })));

    this.subscribe(this.systemPropertyObs.pipe(tap(value => {
      this.searchFacetProperties = value.searchFacets;
    })));
  }

  transform(facetName: string): string {
    if (this.currentLanguage === this.lastReturnLanguage && !isNullOrUndefined(this.lastReturnedValue)) {
      return this.lastReturnedValue;
    } else {
      let value: string = facetName;
      if (!isNullOrUndefined(this.searchFacetProperties) && !isNullOrUndefined(this.currentLanguage)) {
        const facetProperties: FacetProperty[] = this.searchFacetProperties.filter(function (facetProp: FacetProperty): boolean {
          return facetProp.name === facetName;
        });

        if (facetProperties.length === 1) {
          const facetProperty: FacetProperty = facetProperties[0];
          const currentLang: string = this.currentLanguage;
          const labels: Label[] = facetProperty.labels.filter(function (label: Label): boolean {
            return label.language === currentLang;
          });

          if (labels.length === 1) {
            value = labels[0].text;
          }
        }
      }

      this.lastReturnLanguage = this.currentLanguage;
      this.lastReturnedValue = value;
      return value;
    }
  }
}
